// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, Icon};
use glib::translate::*;

glib::wrapper! {
    #[derive(Debug)]
    pub struct UnixMountEntry(Boxed<ffi::GUnixMountEntry>);

    match fn {
        copy => |ptr| ffi::g_unix_mount_entry_copy(mut_override(ptr)),
        free => |ptr| ffi::g_unix_mount_entry_free(ptr),
        type_ => || ffi::g_unix_mount_entry_get_type(),
    }
}

impl UnixMountEntry {
    #[doc(alias = "g_unix_mount_entry_compare")]
    fn compare(&self, mount2: &UnixMountEntry) -> i32 {
        unsafe {
            ffi::g_unix_mount_entry_compare(
                mut_override(self.to_glib_none().0),
                mut_override(mount2.to_glib_none().0),
            )
        }
    }

    #[doc(alias = "g_unix_mount_entry_get_device_path")]
    #[doc(alias = "get_device_path")]
    pub fn device_path(&self) -> std::path::PathBuf {
        unsafe {
            from_glib_none(ffi::g_unix_mount_entry_get_device_path(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_get_fs_type")]
    #[doc(alias = "get_fs_type")]
    pub fn fs_type(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::g_unix_mount_entry_get_fs_type(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_get_mount_path")]
    #[doc(alias = "get_mount_path")]
    pub fn mount_path(&self) -> std::path::PathBuf {
        unsafe {
            from_glib_none(ffi::g_unix_mount_entry_get_mount_path(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[cfg(feature = "v2_58")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_58")))]
    #[doc(alias = "g_unix_mount_entry_get_options")]
    #[doc(alias = "get_options")]
    pub fn options(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_unix_mount_entry_get_options(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[cfg(feature = "v2_60")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
    #[doc(alias = "g_unix_mount_entry_get_root_path")]
    #[doc(alias = "get_root_path")]
    pub fn root_path(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_unix_mount_entry_get_root_path(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_guess_can_eject")]
    pub fn guess_can_eject(&self) -> bool {
        unsafe {
            from_glib(ffi::g_unix_mount_entry_guess_can_eject(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_guess_icon")]
    pub fn guess_icon(&self) -> Icon {
        unsafe {
            from_glib_full(ffi::g_unix_mount_entry_guess_icon(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_guess_name")]
    pub fn guess_name(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::g_unix_mount_entry_guess_name(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_guess_should_display")]
    pub fn guess_should_display(&self) -> bool {
        unsafe {
            from_glib(ffi::g_unix_mount_entry_guess_should_display(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_guess_symbolic_icon")]
    pub fn guess_symbolic_icon(&self) -> Icon {
        unsafe {
            from_glib_full(ffi::g_unix_mount_entry_guess_symbolic_icon(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_is_readonly")]
    pub fn is_readonly(&self) -> bool {
        unsafe {
            from_glib(ffi::g_unix_mount_entry_is_readonly(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_is_system_internal")]
    pub fn is_system_internal(&self) -> bool {
        unsafe {
            from_glib(ffi::g_unix_mount_entry_is_system_internal(mut_override(
                self.to_glib_none().0,
            )))
        }
    }

    #[doc(alias = "g_unix_mount_entry_at")]
    #[doc(alias = "at")]
    pub fn for_mount_path(
        mount_path: impl AsRef<std::path::Path>,
    ) -> (Option<UnixMountEntry>, u64) {
        unsafe {
            let mut time_read = std::mem::MaybeUninit::uninit();
            let ret = from_glib_full(ffi::g_unix_mount_entry_at(
                mount_path.as_ref().to_glib_none().0,
                time_read.as_mut_ptr(),
            ));
            (ret, time_read.assume_init())
        }
    }

    #[doc(alias = "g_unix_mount_entry_for")]
    #[doc(alias = "for")]
    pub fn for_file_path(file_path: impl AsRef<std::path::Path>) -> (Option<UnixMountEntry>, u64) {
        unsafe {
            let mut time_read = std::mem::MaybeUninit::uninit();
            let ret = from_glib_full(ffi::g_unix_mount_entry_for(
                file_path.as_ref().to_glib_none().0,
                time_read.as_mut_ptr(),
            ));
            (ret, time_read.assume_init())
        }
    }
}

impl PartialEq for UnixMountEntry {
    #[inline]
    fn eq(&self, other: &Self) -> bool {
        self.compare(other) == 0
    }
}

impl Eq for UnixMountEntry {}

impl PartialOrd for UnixMountEntry {
    #[inline]
    fn partial_cmp(&self, other: &Self) -> Option<std::cmp::Ordering> {
        Some(self.cmp(other))
    }
}

impl Ord for UnixMountEntry {
    #[inline]
    fn cmp(&self, other: &Self) -> std::cmp::Ordering {
        self.compare(other).cmp(&0)
    }
}

unsafe impl Send for UnixMountEntry {}
unsafe impl Sync for UnixMountEntry {}
