/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.search;

import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class QueryPredicate {
    public static final String AND = "&&";
    public static final String OR = "||";
    public static final String EQUALS = "==";
    public static final String CONTAINS = "contains";
    public static final String CASESENSITIVE = "casesensitive";
    public static final String CASEINSENSITIVE = "caseinsensitive";
    private NSProperty mPropertyName;
    private String[] mPropertyValue;
    private String mComparisonOp;
    private boolean mCaseSensitive;

    public QueryPredicate() {
    }

    public QueryPredicate(NSProperty propName, String propValue, String op, boolean caseSensitive) {
        this.setName(propName);
        this.setValue(propValue);
        this.setOperator(op);
        this.setCaseSensitive(caseSensitive);
    }

    public QueryPredicate(String serialized) {
        if (serialized != null && serialized.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(serialized);
            this.setName(new NSProperty(tokenizer.nextToken(" ")));
            String tmpStr = tokenizer.nextToken(" ");
            if (tmpStr.equals(CASESENSITIVE)) {
                this.setCaseSensitive(true);
            } else {
                this.setCaseSensitive(false);
            }
            this.setOperator(tokenizer.nextToken(" "));
            Vector<String> tmpVec = new Vector<String>();
            while (tokenizer.hasMoreElements()) {
                tmpVec.add(tokenizer.nextToken("|").trim());
            }
            this.setValue(tmpVec);
        }
    }

    public QueryPredicate(NSProperty propName, String propValue, String delimeter, String op, boolean caseSensitive) {
        this.setName(propName);
        this.setValue(propValue, delimeter);
        this.setOperator(op);
        this.setCaseSensitive(caseSensitive);
    }

    public QueryPredicate(NSProperty propName, String[] propValue, String op, boolean caseSensitive) {
        this.setName(propName);
        this.setValue(propValue);
        this.setOperator(op);
        this.setCaseSensitive(caseSensitive);
    }

    public QueryPredicate(NSProperty propName, Vector propValue, String op, boolean caseSensitive) {
        this.setName(propName);
        this.setValue(propValue);
        this.setOperator(op);
        this.setCaseSensitive(caseSensitive);
    }

    public QueryPredicate(String propNamespace, String propLocalName, String propValue, String op, boolean caseSensitive) {
        NSProperty propName = new NSProperty(propNamespace, propLocalName);
        this.setName(propName);
        this.setValue(propValue);
        this.setOperator(op);
        this.setCaseSensitive(caseSensitive);
    }

    public QueryPredicate(String propNamespace, String propLocalName, String propValue, String delimeter, String op, boolean caseSensitive) {
        NSProperty propName = new NSProperty(propNamespace, propLocalName);
        this.setName(propName);
        this.setValue(propValue, delimeter);
        this.setOperator(op);
        this.setCaseSensitive(caseSensitive);
    }

    public QueryPredicate(String propNamespace, String propLocalName, String[] propValue, String op, boolean caseSensitive) {
        NSProperty propName = new NSProperty(propNamespace, propLocalName);
        this.setName(propName);
        this.setValue(propValue);
        this.setOperator(op);
        this.setCaseSensitive(caseSensitive);
    }

    public QueryPredicate(String propNamespace, String propLocalName, Vector propValue, String op, boolean caseSensitive) {
        NSProperty propName = new NSProperty(propNamespace, propLocalName);
        this.setName(propName);
        this.setValue(propValue);
        this.setOperator(op);
        this.setCaseSensitive(caseSensitive);
    }

    public void setName(NSProperty nsProperty) {
        this.mPropertyName = nsProperty;
    }

    public void setName(String propNamespace, String propLocalName) {
        this.mPropertyName = new NSProperty(propNamespace, propLocalName);
    }

    public void setValue(String propValue) {
        if (propValue != null) {
            this.mPropertyValue = new String[1];
            this.mPropertyValue[0] = propValue;
        } else {
            this.mPropertyValue = null;
        }
    }

    public void setValue(String propValue, String delimeter) {
        if (propValue != null) {
            StringTokenizer st = new StringTokenizer(propValue, delimeter);
            if (st.countTokens() > 0) {
                this.mPropertyValue = new String[st.countTokens()];
                int idx = 0;
                while (st.hasMoreTokens()) {
                    this.mPropertyValue[idx] = st.nextToken().trim();
                    ++idx;
                }
            } else {
                this.mPropertyValue = new String[1];
                this.mPropertyValue[0] = propValue;
            }
        } else {
            this.mPropertyValue = null;
        }
    }

    public void setValue(String[] propValue) {
        if (propValue != null && propValue.length > 0) {
            this.mPropertyValue = new String[propValue.length];
            for (int i = 0; i < propValue.length; ++i) {
                this.mPropertyValue[i] = propValue[i];
            }
        } else {
            this.mPropertyValue = null;
        }
    }

    public void setValue(Vector propValues) {
        if (propValues != null && propValues.size() > 0) {
            this.mPropertyValue = new String[propValues.size()];
            for (int i = 0; i < propValues.size(); ++i) {
                this.mPropertyValue[i] = (String)propValues.elementAt(i);
            }
        } else {
            this.mPropertyValue = null;
        }
    }

    public void setOperator(String op) {
        this.mComparisonOp = op;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.mCaseSensitive = caseSensitive;
    }

    public NSProperty getNSProperty() {
        return this.mPropertyName;
    }

    public String getNamespace() {
        return this.mPropertyName.getNamespaceURI();
    }

    public String getLocalName() {
        return this.mPropertyName.getLocalName();
    }

    public String[] getValue() {
        return this.mPropertyValue;
    }

    public String getValueAsString() {
        StringBuffer buf = new StringBuffer();
        for (int idx = 0; idx < this.mPropertyValue.length; ++idx) {
            if (this.mPropertyValue[idx].indexOf(" ") >= 0) {
                buf.append("\"");
                buf.append(this.mPropertyValue[idx]);
                buf.append("\"");
            } else {
                buf.append(this.mPropertyValue[idx]);
            }
            if (idx == this.mPropertyValue.length - 1) continue;
            buf.append(" ");
        }
        return new String(buf);
    }

    public String getOperator() {
        return this.mComparisonOp;
    }

    public boolean getCaseSensitive() {
        return this.mCaseSensitive;
    }

    public String toString() {
        StringBuffer retString = new StringBuffer(this.mPropertyName.toString());
        retString.append(" ");
        if (this.mCaseSensitive) {
            retString.append(CASESENSITIVE);
        } else {
            retString.append(CASEINSENSITIVE);
        }
        retString.append(" ");
        retString.append(this.mComparisonOp);
        for (int i = 0; i < this.mPropertyValue.length - 1; ++i) {
            retString.append(" ");
            retString.append(this.mPropertyValue[i]);
            retString.append(" |");
        }
        retString.append(" ");
        retString.append(this.mPropertyValue[this.mPropertyValue.length - 1]);
        return retString.toString();
    }

    public static Vector parseMultiValueString(String inString) {
        Vector<String> retVec = new Vector<String>();
        StringTokenizer st = new StringTokenizer(inString, " \"", true);
        String newDelimeter = null;
        boolean findMatchingQuote = false;
        try {
            while (st.hasMoreTokens()) {
                String token;
                if (newDelimeter != null) {
                    token = st.nextToken(newDelimeter);
                    newDelimeter = null;
                } else {
                    token = st.nextToken();
                }
                if (token.equals(" ")) continue;
                if (token.equals("\"")) {
                    if (findMatchingQuote) {
                        newDelimeter = " \"";
                        findMatchingQuote = false;
                        continue;
                    }
                    newDelimeter = "\"";
                    findMatchingQuote = true;
                    continue;
                }
                retVec.add(token);
            }
        }
        catch (NoSuchElementException e) {
            Logger log = LoggerUtils.getLogger();
            log.info("Parsing user input: " + inString + " and ran out of tokens");
        }
        return retVec;
    }
}

