/**
 * \file pappsomspp/processing/cbor/cborstreamreaderinterface.h
 * \date 11/02/2025
 * \author Olivier Langella
 * \brief common interface to read CBOR streams with convenient framework
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "cborstreamreaderinterface.h"

pappso::cbor::CborStreamReaderInterface::CborStreamReaderInterface()
{
}

pappso::cbor::CborStreamReaderInterface::~CborStreamReaderInterface()
{
}


bool
pappso::cbor::CborStreamReaderInterface::getExpectedString()
{
  bool is_ok       = false;
  m_expectedString = "";
  qDebug() << mpa_cborReader->type();
  if(mpa_cborReader->type() == QCborStreamReader::String)
    {
      is_ok = mpa_cborReader->decodeString(m_expectedString);
    }

  return is_ok;
}


void
pappso::cbor::CborStreamReaderInterface::initCborReader(QFile *pcborfile)
{

  if(mpa_cborReader != nullptr)
    delete mpa_cborReader;
  mpa_cborReader = nullptr;
  mpa_cborReader = new CborStreamReader();
  // try to mmap the file, this is faster
  char *ptr =
    reinterpret_cast<char *>(pcborfile->map(0, pcborfile->size(), QFile::MapPrivateOption));
  if(ptr)
    {
      // worked
      m_data = QByteArray::fromRawData(ptr, pcborfile->size());
      mpa_cborReader->addData(m_data);
    }
  else if(pcborfile->isSequential())
    {
      // details requires full contents, so allocate memory
      m_data = pcborfile->readAll();
      mpa_cborReader->addData(m_data);
    }
  else
    {
      // just use the QIODevice
      mpa_cborReader->setDevice(pcborfile);
    }
}
