/****************************************************************
 *								*
 * Copyright (c) 2001-2024 Fidelity National Information	*
 * Services, Inc. and/or its subsidiaries. All rights reserved.	*
 *								*
 *	This source code contains the intellectual property	*
 *	of its copyright holder(s), and is made available	*
 *	under a license.  If you do not know the terms of	*
 *	the license, please stop and do not read further.	*
 *								*
 ****************************************************************/

#include "mdef.h"
#include "error.h"
#include "util.h"

error_def(ERR_ASSERT);
error_def(ERR_CTRLC);
error_def(ERR_FORCEDHALT);
error_def(ERR_GTMASSERT);
error_def(ERR_GTMASSERT2);
error_def(ERR_GTMCHECK);
error_def(ERR_MEMORY);
error_def(ERR_OUTOFSPACE);
error_def(ERR_STACKOFLOW);
error_def(ERR_VMSMEMORY);

CONDITION_HANDLER(region_init_ch)
{
	START_CH(TRUE);
	TREF(ok_to_leave_statsdb_unopened) = FALSE;
	if (!(IS_GTM_ERROR(SIGNAL)) || DUMPABLE)
		NEXTCH;
     	PRN_ERROR;
	if (SEVERITY == WARNING || SEVERITY == INFO)
	{
		CONTINUE;
	} else
		UNWIND(NULL, NULL);
}
