/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SaveChangesHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(SaveChangesHandler.class);

    public static boolean validateAndSave(DBRProgressMonitor monitor, ISaveablePart saveable) {
        if (!saveable.isDirty()) {
            return true;
        }
        SaveRunner saveRunner = new SaveRunner(monitor, saveable);
        UIUtils.syncExec((Runnable)saveRunner);
        return saveRunner.getResult();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EntityEditor editor = (EntityEditor)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), EntityEditor.class);
        if (editor != null) {
            try {
                UIUtils.runInProgressService(monitor -> {
                    boolean bl = SaveChangesHandler.validateAndSave(monitor, (ISaveablePart)editor);
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    private static class SaveRunner
    implements Runnable {
        private final DBRProgressMonitor monitor;
        private final ISaveablePart saveable;
        private boolean result;

        private SaveRunner(DBRProgressMonitor monitor, ISaveablePart saveable) {
            this.monitor = monitor;
            this.saveable = saveable;
        }

        public boolean getResult() {
            return this.result;
        }

        @Override
        public void run() {
            int choice = -1;
            ISaveablePart iSaveablePart = this.saveable;
            if (iSaveablePart instanceof ISaveablePart2) {
                ISaveablePart2 saveablePart2 = (ISaveablePart2)iSaveablePart;
                choice = saveablePart2.promptToSaveOnClose();
            } else if (!this.saveable.isDirty()) {
                this.result = true;
                return;
            }
            if (choice == -1 || choice == 3) {
                String saveableName;
                Shell shell;
                ISaveablePart iSaveablePart2 = this.saveable;
                if (iSaveablePart2 instanceof IWorkbenchPart) {
                    IWorkbenchPart workbenchPart = (IWorkbenchPart)iSaveablePart2;
                    shell = workbenchPart.getSite().getShell();
                    saveableName = workbenchPart.getTitle();
                    if (CommonUtils.isEmpty((String)saveableName)) {
                        saveableName = workbenchPart.getTitleToolTip();
                    }
                } else {
                    shell = UIUtils.getActiveWorkbenchShell();
                    saveableName = CommonUtils.toString((Object)this.saveable);
                }
                int confirmResult = ConfirmationDialog.confirmAction((Shell)shell, (String)"close_editor_edit", (int)6, (Object[])new Object[]{saveableName});
                choice = switch (confirmResult) {
                    case 2 -> 0;
                    case 3 -> 1;
                    default -> 2;
                };
            }
            switch (choice) {
                case 0: {
                    this.saveable.doSave(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)this.monitor));
                    if (this.saveable.isDirty()) {
                        log.debug((Object)("Savable '" + String.valueOf(this.saveable) + "' is still dirty after save"));
                    }
                    this.result = true;
                    break;
                }
                case 1: {
                    this.result = true;
                    break;
                }
                default: {
                    this.result = false;
                }
            }
        }
    }
}

