/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.snowflake.ui;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.snowflake.ui.SnowflakeConnectionPageAdvanced;
import org.jkiss.dbeaver.ext.snowflake.ui.internal.SnowflakeMessages;
import org.jkiss.dbeaver.ext.snowflake.ui.internal.SnowflakeUIActivator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SnowflakeConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider,
IDataSourceConnectionTester {
    private static final Log log = Log.getLog(SnowflakeConnectionPage.class);
    private Text hostText;
    private Text portText;
    private Combo dbText;
    private Combo warehouseText;
    private Combo schemaText;
    private static final ImageDescriptor logoImage = SnowflakeUIActivator.getImageDescriptor("icons/snowflake_logo.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group addrGroup = UIUtils.createControlGroup((Composite)control, (String)SnowflakeMessages.label_connection, (int)4, (int)0, (int)0);
        GridData gd = new GridData(768);
        addrGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowflakeMessages.label_host);
        this.hostText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.hostText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowflakeMessages.label_port);
        this.portText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
        this.portText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.portText);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowflakeMessages.label_database);
        this.dbText = new Combo((Composite)addrGroup, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.dbText);
        this.dbText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowflakeMessages.label_warehouse);
        this.warehouseText = new Combo((Composite)addrGroup, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.warehouseText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.warehouseText);
        this.warehouseText.addModifyListener(textListener);
        UIUtils.createControlLabel((Composite)addrGroup, (String)SnowflakeMessages.label_schema);
        this.schemaText = new Combo((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.schemaText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.schemaText);
        this.schemaText.addModifyListener(textListener);
        Composite ph = UIUtils.createPlaceholder((Composite)control, (int)2);
        UIUtils.createInfoLabel((Composite)ph, (String)"");
        Link testLink = new Link(ph, 0);
        testLink.setText(SnowflakeMessages.label_click_on_test_connection);
        GridData gd2 = new GridData(800);
        gd2.grabExcessHorizontalSpace = true;
        testLink.setLayoutData((Object)gd2);
        testLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnowflakeConnectionPage.this.site.testConnection();
            }
        });
        this.createAuthPanel(control, 1);
        this.createDriverPanel(control);
        this.setControl((Control)control);
    }

    public boolean isComplete() {
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(".snowflakecomputing.com");
            } else {
                this.hostText.setText(connectionInfo.getHostName());
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                databaseName = "TEST_DB";
            }
            this.dbText.setText(databaseName);
        }
        if (this.warehouseText != null) {
            this.warehouseText.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
        }
        if (this.schemaText != null) {
            this.schemaText.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("@dbeaver-schema@")));
        }
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "snowflake_snowflake";
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.warehouseText != null) {
            connectionInfo.setServerName(this.warehouseText.getText().trim());
        }
        if (this.schemaText != null) {
            connectionInfo.setProviderProperty("@dbeaver-schema@", this.schemaText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    public void testConnection(DBCSession session) {
        try {
            SnowflakeConnectionPage.loadDictList(session, this.dbText, "SHOW DATABASES");
            SnowflakeConnectionPage.loadDictList(session, this.warehouseText, "SHOW WAREHOUSES");
            SnowflakeConnectionPage.loadDictList(session, this.schemaText, "SHOW SCHEMAS");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private static void loadDictList(DBCSession session, Combo combo, String query) throws DBException {
        ArrayList<String> result = new ArrayList<String>();
        session.getProgressMonitor().subTask("Exec " + query);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query, false, false, false);){
            dbStat.executeStatement();
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (DBCResultSet dbResult = dbStat.openResultSet();){
                while (dbResult.nextRow()) {
                    result.add(CommonUtils.toString((Object)dbResult.getAttributeValue("name")));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        UIUtils.asyncExec(() -> {
            String oldText = combo.getText();
            if (!result.contains(oldText)) {
                result.add(0, oldText);
            }
            if (!result.contains("")) {
                result.add(0, "");
            }
            combo.setItems(result.toArray(new String[0]));
            combo.setText(oldText);
        });
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new SnowflakeConnectionPageAdvanced(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

