/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import com.sun.security.auth.module.NTSystem;
import com.sun.security.auth.module.UnixSystem;
import java.time.LocalDateTime;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.auth.SMSessionSecretKeeper;
import org.jkiss.dbeaver.model.auth.SMSessionType;
import org.jkiss.dbeaver.model.auth.impl.AbstractSessionPersistent;
import org.jkiss.dbeaver.model.impl.app.LocalSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class LocalWorkspaceSession
extends AbstractSessionPersistent
implements SMSession,
SMSessionPrincipal,
SMSessionSecretKeeper {
    public static final SMSessionType DB_SESSION_TYPE = new SMSessionType("DBeaver");
    private final DBPWorkspace workspace;
    private String userName;
    private String domainName;
    private final LocalDateTime startTime;

    public LocalWorkspaceSession(@NotNull DBPWorkspace workspace) {
        this.workspace = workspace;
        try {
            if (RuntimeUtils.isWindows()) {
                NTSystem ntSystem = new NTSystem();
                this.userName = ntSystem.getName();
                this.domainName = ntSystem.getDomain();
            } else {
                UnixSystem unixSystem = new UnixSystem();
                this.userName = unixSystem.getUsername();
            }
        }
        catch (Exception exception) {}
        if (CommonUtils.isEmpty((String)this.userName)) {
            this.userName = System.getProperty("user.name");
        }
        if (CommonUtils.isEmpty((String)this.userName)) {
            this.userName = "unknown";
        }
        if (CommonUtils.isEmpty((String)this.domainName)) {
            if (RuntimeUtils.isWindows()) {
                this.domainName = System.getenv("USERDOMAIN");
            }
            if (CommonUtils.isEmpty((String)this.domainName)) {
                this.domainName = "local";
            }
        }
        this.startTime = LocalDateTime.now();
    }

    @Override
    @NotNull
    public SMAuthSpace getSessionSpace() {
        return this.workspace;
    }

    @Override
    @NotNull
    public SMSessionContext getSessionContext() {
        return this.workspace.getAuthContext();
    }

    @Override
    @Nullable
    public SMSessionPrincipal getSessionPrincipal() {
        return this;
    }

    @Override
    @NotNull
    public String getSessionId() {
        return this.workspace.getWorkspaceId();
    }

    @Override
    @NotNull
    public LocalDateTime getSessionStart() {
        return this.startTime;
    }

    @Override
    public String getUserDomain() {
        return this.domainName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    @NotNull
    public DBSSecretController getSecretController() {
        return LocalSecretController.INSTANCE;
    }
}

