"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = mergeClasses;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _utils = require("@mui/utils");
function mergeClasses(options = {}) {
  const {
    baseClasses,
    newClasses,
    Component
  } = options;
  if (!newClasses) {
    return baseClasses;
  }
  const nextClasses = (0, _extends2.default)({}, baseClasses);
  if (process.env.NODE_ENV !== 'production') {
    if (typeof newClasses === 'string') {
      console.error([`MUI: The value \`${newClasses}\` ` + `provided to the classes prop of ${(0, _utils.getDisplayName)(Component)} is incorrect.`, 'You might want to use the className prop instead.'].join('\n'));
      return baseClasses;
    }
  }
  Object.keys(newClasses).forEach(key => {
    if (process.env.NODE_ENV !== 'production') {
      if (!baseClasses[key] && newClasses[key]) {
        console.error([`MUI: The key \`${key}\` ` + `provided to the classes prop is not implemented in ${(0, _utils.getDisplayName)(Component)}.`, `You can only override one of the following: ${Object.keys(baseClasses).join(',')}.`].join('\n'));
      }
      if (newClasses[key] && typeof newClasses[key] !== 'string') {
        console.error([`MUI: The key \`${key}\` ` + `provided to the classes prop is not valid for ${(0, _utils.getDisplayName)(Component)}.`, `You need to provide a non empty string instead of: ${newClasses[key]}.`].join('\n'));
      }
    }
    if (newClasses[key]) {
      nextClasses[key] = `${baseClasses[key]} ${newClasses[key]}`;
    }
  });
  return nextClasses;
}