"use strict";
exports.hr = void 0;
var _index = require("./hr/_lib/formatDistance.js");
var _index2 = require("./hr/_lib/formatLong.js");
var _index3 = require("./hr/_lib/formatRelative.js");
var _index4 = require("./hr/_lib/localize.js");
var _index5 = require("./hr/_lib/match.js");

/**
 * @category Locales
 * @summary Croatian locale.
 * @language Croatian
 * @iso-639-2 hrv
 * @author Matija Marohnić [@silvenon](https://github.com/silvenon)
 * @author Manico [@manico](https://github.com/manico)
 * @author Ivan Jeržabek [@jerzabek](https://github.com/jerzabek)
 */
const hr = (exports.hr = {
  code: "hr",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 1,
  },
});
