"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jaJP = void 0;

var _getPickersLocalization = require("./utils/getPickersLocalization");

// maps ClockPickerView to its translation
const clockViews = {
  hours: '時間',
  minutes: '分',
  seconds: '秒'
}; // maps PickersToolbar["viewType"] to its translation

const pickerViews = {
  calendar: 'カレンダー表示',
  clock: '時計表示'
};
const jaJPPickers = {
  // Calendar navigation
  previousMonth: '先月',
  nextMonth: '来月',
  // View navigation
  openPreviousView: '前の表示を開く',
  openNextView: '次の表示を開く',
  calendarViewSwitchingButtonAriaLabel: view => view === 'year' ? '年選択表示からカレンダー表示に切り替える' : 'カレンダー表示から年選択表示に切り替える',
  inputModeToggleButtonAriaLabel: (isKeyboardInputOpen, viewType) => isKeyboardInputOpen ? `テキスト入力表示から${pickerViews[viewType]}に切り替える` : `${pickerViews[viewType]}からテキスト入力表示に切り替える`,
  // DateRange placeholders
  start: '開始',
  end: '終了',
  // Action bar
  cancelButtonLabel: 'キャンセル',
  clearButtonLabel: 'クリア',
  okButtonLabel: '確定',
  todayButtonLabel: '今日',
  // Toolbar titles
  datePickerDefaultToolbarTitle: '日付を選択',
  dateTimePickerDefaultToolbarTitle: '日時を選択',
  timePickerDefaultToolbarTitle: '時間を選択',
  dateRangePickerDefaultToolbarTitle: '日付の範囲を選択',
  // Clock labels
  clockLabelText: (view, time, adapter) => {
    var _clockViews$view;

    return `${(_clockViews$view = clockViews[view]) != null ? _clockViews$view : view}を選択してください ${time === null ? '時間が選択されていません' : `選択した時間は ${adapter.format(time, 'fullTime')} です`}`;
  },
  hoursClockNumberText: hours => `${hours} ${clockViews.hours}`,
  minutesClockNumberText: minutes => `${minutes} ${clockViews.minutes}`,
  secondsClockNumberText: seconds => `${seconds} ${clockViews.seconds}`,
  // Open picker labels
  openDatePickerDialogue: (value, utils) => value !== null && utils.isValid(value) ? `日付を選択してください。選択した日付は ${utils.format(value, 'fullDate')} です` : '日付を選択してください',
  openTimePickerDialogue: (value, utils) => value !== null && utils.isValid(value) ? `時間を選択してください。選択した時間は ${utils.format(value, 'fullTime')} です` : '時間を選択してください',
  // Table labels
  timeTableLabel: '時間を選択',
  dateTableLabel: '日付を選択'
};
const jaJP = (0, _getPickersLocalization.getPickersLocalization)(jaJPPickers);
exports.jaJP = jaJP;