# -*- coding: utf-8 -*-
# Copyright 2025 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the nxos_interfaces module
"""


class InterfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the nxos_interfaces module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "description": {"type": "str"},
                "enabled": {"type": "bool"},
                "speed": {"type": "str"},
                "mode": {"choices": ["layer2", "layer3"], "type": "str"},
                "mtu": {"type": "str"},
                "duplex": {"type": "str", "choices": ["full", "half", "auto"]},
                "ip_forward": {"type": "bool"},
                "fabric_forwarding_anycast_gateway": {"type": "bool"},
                "mac_address": {"type": "str"},
                "logging": {
                    "type": "dict",
                    "options": {
                        "link_status": {"type": "bool"},
                        "trunk_status": {"type": "bool"},
                    },
                },
                "snmp": {
                    "type": "dict",
                    "options": {
                        "trap": {
                            "type": "dict",
                            "options": {"link_status": {"type": "bool"}},
                        },
                    },
                },
                "service_policy": {
                    "type": "dict",
                    "options": {
                        "input": {"type": "str"},
                        "output": {"type": "str"},
                        "type_options": {
                            "type": "dict",
                            "options": {
                                "qos": {
                                    "type": "dict",
                                    "options": {
                                        "input": {"type": "str"},
                                        "output": {"type": "str"},
                                    },
                                },
                                "queuing": {
                                    "type": "dict",
                                    "options": {
                                        "input": {"type": "str"},
                                        "output": {"type": "str"},
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
        "running_config": {"type": "str"},
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "rendered",
                "parsed",
                "purged",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
