% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{flextable_dim}
\alias{flextable_dim}
\title{Get width and height of a flextable object}
\usage{
flextable_dim(x, unit = "in")
}
\arguments{
\item{x}{a flextable object}

\item{unit}{unit for returned values, one of "in", "cm", "mm".}
}
\description{
Returns the width, height and
aspect ratio of a flextable in a named list.
The aspect ratio is the ratio corresponding to \code{height/width}.

Names of the list are \code{widths}, \code{heights} and \code{aspect_ratio}.
}
\examples{
ftab <- flextable(head(iris))
flextable_dim(ftab)
ftab <- autofit(ftab)
flextable_dim(ftab)
}
\seealso{
Other functions for flextable size management: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{width}()}
}
\concept{functions for flextable size management}
