/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.protocol.v2api.EntityTranslator;
import com.paterva.maltego.transform.protocol.v2api.NotificationTranslator;
import com.paterva.maltego.transform.protocol.v2api.TransformRunnerV2;
import com.paterva.maltego.transform.protocol.v2api.V2MatchingRuleDescriptor;
import com.paterva.maltego.transform.protocol.v2api.api.InvalidKeyException;
import com.paterva.maltego.transform.protocol.v2api.api.KeyLimitReachedException;
import com.paterva.maltego.transform.protocol.v2api.api.KeyRequiredException;
import com.paterva.maltego.transform.protocol.v2api.messaging.AdditionalInfoButton;
import com.paterva.maltego.transform.protocol.v2api.messaging.CanceledMessage;
import com.paterva.maltego.transform.protocol.v2api.messaging.EntityDescriptor;
import com.paterva.maltego.transform.protocol.v2api.messaging.ExceptionResponse;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageWrapper;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformResponse;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformResponseNonBody;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class V2TransformRunner
extends TransformRunnerV2 {
    private final TransformDescriptor _transform;

    public V2TransformRunner(GraphID graphID, TransformDescriptor transform, EntityFactory factory, EntityRegistry registry) {
        super(graphID, factory, registry);
        this._transform = transform;
    }

    protected abstract MaltegoMessageWrapper runTransform(MaltegoEntity var1) throws TransformRunException, IOException;

    public TransformDescriptor getTransform() {
        return this._transform;
    }

    @Override
    protected TransformRunnerV2.RunResultV2 doRunTransform(MaltegoEntity input) throws Exception {
        MaltegoMessageWrapper wrapper = this.runTransform(input);
        if (wrapper != null) {
            if (wrapper instanceof CanceledMessage) {
                CanceledMessage msg = (CanceledMessage)wrapper;
                TransformRunnerV2.RunResultV2 runResult = new TransformRunnerV2.RunResultV2(input);
                TransformMessage transformMsg = new TransformMessage(msg.getMessage());
                transformMsg.setSeverity(TransformMessage.Severity.Warning);
                runResult.getMessages().add(transformMsg);
                return runResult;
            }
            TransformResponse response = wrapper.getTransformResponse();
            if (!GraphStoreRegistry.getDefault().isExistingAndOpen(this.getGraphID())) {
                return new TransformRunnerV2.RunResultV2(input);
            }
            if (response == null) {
                ExceptionResponse.MaltegoException firstException;
                ExceptionResponse exception = wrapper.getExceptionResponse();
                if (exception == null) {
                    throw new TransformRunException("NULL response received");
                }
                ArrayList<ExceptionResponse.MaltegoException> exceptions = exception.getExceptions();
                ExceptionResponse.MaltegoException maltegoException = firstException = exceptions.isEmpty() ? null : exceptions.get(0);
                if (firstException != null) {
                    if (firstException.getCode() == ExceptionResponse.INVALID_KEY) {
                        throw new InvalidKeyException(firstException.getMessage());
                    }
                    if (firstException.getCode() == ExceptionResponse.KEY_LIMIT_REACHED) {
                        throw new KeyLimitReachedException(firstException.getMessage());
                    }
                    if (firstException.getCode() == ExceptionResponse.KEY_REQUIRED) {
                        throw new KeyRequiredException(firstException.getMessage());
                    }
                    throw new TransformRunException(firstException.getMessage());
                }
                throw new TransformRunException("Empty exception response received");
            }
            Collection<TransformResponse.Notification> messages = response.getMessages();
            TransformResponseNonBody responseBody = wrapper.getTransformResponseNonBody();
            if (responseBody == null) {
                responseBody = new TransformResponseNonBody(200);
            }
            int statusCode = responseBody.getStatusCode();
            if (messages != null && messages.size() >= 0 && statusCode >= 201 && statusCode < 300) {
                return this.translateResponse(input, response, this.getFactory(), this.getRegistry(), statusCode, response.getAdditionalInfo().orElse(new TransformResponse.AdditionalInfo()).getButtons());
            }
            return this.translateResponse(input, response, this.getFactory(), this.getRegistry(), 0, Collections.emptyList());
        }
        throw new TransformRunException("No response received");
    }

    protected TransformRunnerV2.RunResultV2 translateResponse(MaltegoEntity input, TransformResponse response, EntityFactory factory, EntityRegistry registry, int code, Collection<AdditionalInfoButton> buttons) throws TypeInstantiationException {
        Collection<EntityDescriptor> entities = response.getEntities();
        TransformRunnerV2.RunResultV2 result = new TransformRunnerV2.RunResultV2(input);
        NotificationTranslator nt = new NotificationTranslator();
        result.getEntities().addAll(EntityTranslator.instance().toEntities(entities, factory, registry));
        result.getMessages().addAll(nt.translate(response.getMessages(), code, buttons));
        this.updateMatchingRule(entities);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMatchingRule(Collection<EntityDescriptor> entities) {
        TransformDescriptor transformDescriptor = this._transform;
        synchronized (transformDescriptor) {
            V2MatchingRuleDescriptor rule;
            MatchingRuleDescriptor matchingRule = this._transform.getMatchingRule();
            if (matchingRule instanceof V2MatchingRuleDescriptor) {
                rule = (V2MatchingRuleDescriptor)matchingRule;
            } else {
                rule = new V2MatchingRuleDescriptor();
                this._transform.setMatchingRule((MatchingRuleDescriptor)rule);
            }
            if (entities != null) {
                Set<String> types = entities.stream().map(EntityDescriptor::getTypeName).collect(Collectors.toSet());
                rule.reset(types);
            }
            rule.update(entities, this.getRegistry());
        }
    }
}

