/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.controls.DateTimePicker;
import com.paterva.maltego.typing.editing.form.adapters.AbstractControlAdapter;
import com.paterva.maltego.typing.types.DateTime;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;

class DateTimePickerAdapter
extends AbstractControlAdapter<DateTimePicker, DateTime> {
    private DateFormat _format;

    public DateTimePickerAdapter(DateFormat format) {
        this._format = format;
    }

    @Override
    public DateTimePicker create() {
        DateTimePicker control = new DateTimePicker();
        control.setFormats(new DateFormat[]{this._format});
        control.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("datePickerCommit".equals(e.getActionCommand())) {
                    DateTimePickerAdapter.this.fireActionPerformed(e);
                }
            }
        });
        control.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("date".equals(e.getPropertyName())) {
                    DateTimePickerAdapter.this.fireActionPerformed(null);
                }
            }
        });
        return control;
    }

    @Override
    protected void set(DateTimePicker component, DateTime value) {
        Date date = null;
        if (value != null) {
            date = value.getDate();
        }
        component.setDate(date);
    }

    @Override
    protected DateTime get(DateTimePicker component) {
        Date date = component.getDate();
        if (date != null) {
            return new DateTime(date);
        }
        return null;
    }

    @Override
    protected boolean empty(DateTimePicker component) {
        return component.getDate() == null;
    }

    @Override
    protected void setBackground(DateTimePicker component, Color color) {
        component.getEditor().setBackground(color);
    }

    @Override
    protected Color getBackground(DateTimePicker component) {
        return component.getEditor().getBackground();
    }
}

