/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaCheckBoxUI;
import com.bulenkov.darcula.ui.DarculaMenuItemUIBase;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import sun.swing.MenuItemLayoutHelper;

public class DarculaCheckBoxMenuItemUI
extends DarculaMenuItemUIBase {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaCheckBoxMenuItemUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "CheckBoxMenuItem";
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsUtil.setupTextAntialiasing(g, c);
        super.paint(g, c);
    }

    @Override
    protected void paintText(Graphics g, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr) {
        super.paintText(g, lh, lr);
    }

    @Override
    protected void paintCheckIcon(Graphics g2, MenuItemLayoutHelper lh, MenuItemLayoutHelper.LayoutResult lr, Color holdc, Color foreground) {
        Graphics2D g = (Graphics2D)g2;
        JMenuItem b = lh.getMenuItem();
        Rectangle iconRect = lr.getCheckRect();
        if (b.isSelected() && b.getSelectedIcon() != null) {
            b.getSelectedIcon().paintIcon(b, g, iconRect.x + 4, iconRect.y + 2);
        } else if (!b.isSelected() && b.getIcon() != null) {
            b.getIcon().paintIcon(b, g, iconRect.x + 4, iconRect.y + 2);
        } else {
            int x = iconRect.x + 2;
            int y = iconRect.y + 3;
            int w = iconRect.width - 6;
            int h = iconRect.height - 6;
            g.translate(x, y);
            GradientPaint paint = new GradientPaint(w / 2, 0.0f, b.getBackground().brighter(), w / 2, h, b.getBackground());
            g.setPaint(paint);
            g.fillRect(1, 1, w - 2, h - 2);
            GraphicsConfig config = new GraphicsConfig(g);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            boolean armed = b.getModel().isArmed();
            if (b.hasFocus()) {
                g.setPaint(new GradientPaint(w / 2, 1.0f, DarculaCheckBoxUI.getFocusedBackgroundColor1(armed), w / 2, h, DarculaCheckBoxUI.getFocusedBackgroundColor2(armed)));
            } else {
                g.setPaint(new GradientPaint(w / 2, 1.0f, DarculaCheckBoxUI.getBackgroundColor1(), w / 2, h, DarculaCheckBoxUI.getBackgroundColor2()));
            }
            g.fillRect(0, 0, w, h - 1);
            if (b.getModel().isSelected()) {
                g.setPaint(DarculaCheckBoxUI.getBorderSelectedColor(b.isEnabled()));
                g.drawRect(0, 0, w, h - 1);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g.setStroke(new BasicStroke(2.0f, 1, 1));
                g.setPaint(DarculaCheckBoxUI.getCheckSignColor(b.isEnabled()));
                g.drawLine(3, 5, 6, 8);
                g.drawLine(6, 8, w, 0);
            } else {
                g.setPaint(DarculaCheckBoxUI.getBorderColor(b.isEnabled()));
                g.drawRect(0, 0, w, h - 1);
            }
            g.translate(-x, -y);
            config.restore();
        }
        g.setColor(foreground);
    }
}

