/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.lucene.serialize.NumericTypeConverter;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;

class LongConverter
extends NumericTypeConverter<Long> {
    private static final Long MIN_SORT_VALUE = Long.MIN_VALUE;
    private static final Long MAX_SORT_VALUE = Long.MAX_VALUE;

    public LongConverter() {
        super("long", Long.class, Long.TYPE, SortField.Type.LONG);
    }

    @Override
    Long toType(Number number) {
        return number.longValue();
    }

    @Override
    IndexableField createNumberField(Long value, String fieldName) {
        return new LongField(fieldName, value.longValue(), Field.Store.YES);
    }

    @Override
    long toSortableLong(Long value) {
        return value;
    }

    @Override
    protected Long getMinSortField() {
        return MIN_SORT_VALUE;
    }

    @Override
    protected Long getMaxSortField() {
        return MAX_SORT_VALUE;
    }
}

