/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.ConstraintStringMatchTypeEnum;
import com.paterva.maltego.transform.descriptor.ConstraintTargetTypeEnum;
import com.paterva.maltego.transform.descriptor.ConstraintTypeEnum;
import com.paterva.maltego.transform.descriptor.InputConstraint;
import com.paterva.maltego.transform.descriptor.LogicalOperation;
import java.util.List;
import java.util.regex.Pattern;

public class StringMatchConstraint
extends InputConstraint {
    protected final String value;
    protected final ConstraintStringMatchTypeEnum matchType;
    private final Pattern regexPattern;
    private final Boolean ignoreCase;

    public StringMatchConstraint(String value, ConstraintStringMatchTypeEnum matchType, Boolean ignoreCase, ConstraintTargetTypeEnum targetType, ConstraintTypeEnum constraintType) {
        this.value = value;
        this.matchType = matchType == null ? ConstraintStringMatchTypeEnum.EQUALS : matchType;
        this.ignoreCase = ignoreCase;
        this.regexPattern = matchType == ConstraintStringMatchTypeEnum.REGEX ? Pattern.compile(value) : null;
        this.constraintType = constraintType;
        this.constraintTargetType = targetType;
    }

    @Override
    public boolean evaluate(List<String> listInputs) {
        if (listInputs == null || listInputs.isEmpty()) {
            return false;
        }
        return listInputs.stream().anyMatch(name -> this.matches((String)name));
    }

    protected boolean matches(String valueToCheck) {
        String valueToCompare = this.value;
        if (valueToCheck == null) {
            return false;
        }
        if (this.ignoreCase != null && this.ignoreCase.booleanValue()) {
            valueToCheck = valueToCheck.toLowerCase();
            valueToCompare = valueToCompare.toLowerCase();
        }
        switch (this.matchType) {
            case CONTAINS: {
                return valueToCheck.contains(valueToCompare);
            }
            case STARTSWITH: {
                return valueToCheck.startsWith(valueToCompare);
            }
            case ENDSWITH: {
                return valueToCheck.endsWith(valueToCompare);
            }
            case EQUALS: {
                return valueToCheck.equals(valueToCompare);
            }
            case EQUALSIGNORECASE: {
                return valueToCheck.equalsIgnoreCase(valueToCompare);
            }
            case REGEX: {
                return this.regexPattern != null && this.regexPattern.matcher(valueToCheck).matches();
            }
        }
        throw new IllegalArgumentException("Invalid matchType: " + (Object)((Object)this.matchType));
    }

    @Override
    public LogicalOperation getConstraintOperation() {
        return LogicalOperation.ALL;
    }

    public String getValue() {
        return this.value;
    }

    public ConstraintStringMatchTypeEnum getMatchType() {
        return this.matchType;
    }

    public Boolean getIgnoreCase() {
        return this.ignoreCase;
    }
}

