/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.InheritedTypesProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompoundConstraint<T extends Constraint>
implements Constraint,
Iterable<T> {
    private List<T> _constraints;

    public CompoundConstraint() {
    }

    public CompoundConstraint(CompoundConstraint<T> constraint) {
        this.constraints().addAll(super.constraints());
    }

    public void add(T constraint) {
        this.constraints().add(constraint);
    }

    @Override
    public Iterator<T> iterator() {
        return this.constraints().iterator();
    }

    private List<T> constraints() {
        if (this._constraints == null) {
            this._constraints = new LinkedList<T>();
        }
        return this._constraints;
    }

    public void remove(T constraint) {
        if (this._constraints != null) {
            this._constraints.remove(constraint);
        }
    }

    @Override
    public boolean isSatisfiedByAny(Iterable<? extends TypedPropertyBag> entities, InheritedTypesProvider typeProvider) {
        if (this._constraints == null) {
            return true;
        }
        for (Constraint c : this._constraints) {
            boolean satisfied = c.isSatisfiedByAny(entities, typeProvider);
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSatisfiedByAny(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
        if (this._constraints == null) {
            return true;
        }
        for (Constraint c : this._constraints) {
            boolean satisfied = c.isSatisfiedByAny(graphID, entities, typeProvider);
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<EntityID> getSatisfiedBy(GraphID graphID, Set<EntityID> entities, InheritedTypesProvider typeProvider) {
        HashSet<EntityID> satisfied = new HashSet<EntityID>();
        if (this._constraints == null) {
            for (EntityID entityID : entities) {
                satisfied.add(entityID);
            }
        } else {
            for (Constraint c : this._constraints) {
                satisfied.addAll(c.getSatisfiedBy(graphID, entities, typeProvider));
            }
        }
        return satisfied;
    }

    @Override
    public Map<EntityID, MaltegoEntity> getSatisfiedBy(GraphID graphID, Map<EntityID, MaltegoEntity> entities, InheritedTypesProvider typeProvider) {
        HashMap<EntityID, MaltegoEntity> satisfied = new HashMap<EntityID, MaltegoEntity>();
        if (this._constraints == null) {
            for (Map.Entry entry : satisfied.entrySet()) {
                EntityID entityID = (EntityID)entry.getKey();
                MaltegoEntity entity = (MaltegoEntity)entry.getValue();
                satisfied.put(entityID, entity);
            }
        } else {
            for (Constraint c : this._constraints) {
                satisfied.putAll(c.getSatisfiedBy(graphID, entities, typeProvider));
            }
        }
        return satisfied;
    }

    @Override
    public boolean isSatisfiedByInheritedTypes(Collection<String> types) {
        if (this._constraints == null) {
            return true;
        }
        for (Constraint c : this._constraints) {
            boolean satisfied = c.isSatisfiedByInheritedTypes(types);
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDisplay() {
        if (this._constraints == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Constraint c : this._constraints) {
            builder.append(c.getDisplay());
            if (i < this._constraints.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplay();
    }

    @Override
    public List<String> getInputTypeNames() {
        ArrayList<String> types = new ArrayList<String>();
        if (this._constraints != null) {
            for (Constraint c : this._constraints) {
                types.add(c.getDisplay());
            }
        }
        return types;
    }
}

