/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api.option;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.seeds.api.test.TestHubJson;
import com.paterva.maltego.util.StringUtilities;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;

public class DataHubOptionProcessor
extends OptionProcessor {
    private static final Logger LOGGER = Logger.getLogger(DataHubOptionProcessor.class.getName());
    private static final Option DATA_HUB_JSON = Option.requiredArgument((char)'d', (String)"dhub");

    protected Set<Option> getOptions() {
        A licenseMode = LicenseManager.A().A(false);
        if (licenseMode.U() && !MaltegoIdProductRestrictions.isProbablyFree((A)licenseMode) && MaltegoIdProductRestrictions.showHubAllowed((A)licenseMode)) {
            return Collections.singleton(DATA_HUB_JSON);
        }
        return Collections.EMPTY_SET;
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        String[] args;
        if (optionValues.containsKey(DATA_HUB_JSON) && (args = optionValues.get(DATA_HUB_JSON)) != null && args.length == 2) {
            String hubFilterUrlStr;
            String hubUrlStr = args[0];
            if (!StringUtilities.isNullOrEmpty((String)hubUrlStr)) {
                TestHubJson.setHubUrlString(hubUrlStr);
                LOGGER.log(Level.INFO, "Data Hub URL: {0}", hubUrlStr);
            }
            if (!StringUtilities.isNullOrEmpty((String)(hubFilterUrlStr = args[1]))) {
                TestHubJson.setHubFiltersUrlString(hubFilterUrlStr);
                LOGGER.log(Level.INFO, "Data Hub Filter URL: {0}", hubFilterUrlStr);
            }
        }
    }
}

