/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.cache.skeletons.EntitySkeletonProvider;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.ui.graph.HoverContext;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeComponent;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeComponents;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeRenderInfo;
import com.paterva.maltego.ui.graph.view2d.EntityNodeHotSpotPainter;
import com.paterva.maltego.ui.graph.view2d.EntityValueLabel;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUtils;
import com.paterva.maltego.ui.graph.view2d.NotesLabel;
import com.paterva.maltego.ui.graph.view2d.PaintPruner;
import com.paterva.maltego.ui.graph.view2d.PinUtils;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import org.jdesktop.swingx.color.ColorUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import yguard.A.J.BA;
import yguard.A.J.HA;
import yguard.A.J.X;
import yguard.A.J.gB;

public class LightweightEntityRealizer
extends HA {
    private static final Logger LOG = Logger.getLogger(LightweightEntityRealizer.class.getName());
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static String _config = null;
    private GraphEntity _graphEntity;
    private MaltegoEntity _entitySkeleton = null;
    private CollectionNodeRenderInfo _collectionNodeInfo = null;
    private final int _paintHash = PaintPruner.generatePaintHash();
    private boolean _sizeDirty = true;
    private boolean _sizeModificationAllowed = false;

    public LightweightEntityRealizer() {
        this.setConfiguration(LightweightEntityRealizer.getConfig());
        this.deflate();
    }

    public LightweightEntityRealizer(BA nr) {
        super(nr);
        this.setCenter(nr.getCenterX(), nr.getCenterY());
    }

    public BA createCopy(BA nr) {
        return new LightweightEntityRealizer(nr);
    }

    public void setUserData(Object o) {
        if (o != null && !(o instanceof GraphEntity)) {
            throw new IllegalArgumentException("User object must be a GraphEntity: " + o.getClass());
        }
        if (Utilities.compareObjects((Object)o, (Object)this._graphEntity)) {
            return;
        }
        this._graphEntity = (GraphEntity)o;
        if (this._graphEntity == null) {
            this.deflate();
            this.removeAllPorts();
        } else {
            EntityPainter painter = EntityPainterSettings.getDefault().getEntityPainter(this._graphEntity.getGraphID());
            painter.update(this, true);
        }
    }

    public void setSizeForce(double width, double height) {
        this._sizeModificationAllowed = true;
        this.setSize(width, height);
        this._sizeModificationAllowed = false;
    }

    public void setSize(double width, double height) {
        if (this._sizeModificationAllowed) {
            super.setSize(width, height);
        }
    }

    public Object getUserData() {
        return this.getGraphEntity();
    }

    public GraphEntity getGraphEntity() {
        return this._graphEntity;
    }

    public boolean isCollectionNode() {
        boolean isCollectionNode = false;
        try {
            GraphStoreView view = this.getGraphStoreView();
            if (view != null) {
                isCollectionNode = view.getModelViewMappings().isOnlyViewEntity((EntityID)this._graphEntity.getID());
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return isCollectionNode;
    }

    private GraphStoreView getGraphStoreView() {
        return this._graphEntity == null ? null : GraphStoreViewRegistry.getDefault().getDefaultView(this._graphEntity.getGraphID());
    }

    public MaltegoEntity getEntitySkeleton() {
        return this._entitySkeleton;
    }

    public CollectionNodeRenderInfo getCollectionNodeInfo() {
        return this._collectionNodeInfo;
    }

    public boolean isInflated() {
        return this._entitySkeleton != null || this._collectionNodeInfo != null;
    }

    public void inflate(MaltegoEntity entitySkeleton) {
        LOG.log(Level.FINE, "{0} inflate", this._graphEntity);
        if (this._collectionNodeInfo != null) {
            throw new IllegalStateException("Already inflated as collection node");
        }
        this._entitySkeleton = entitySkeleton;
        this.setSizeDirty(true);
    }

    public void inflateCollectionNode() {
        LOG.log(Level.FINE, "{0} inflate collection", this._graphEntity);
        if (this._entitySkeleton != null) {
            throw new IllegalStateException("Already inflated as normal entity");
        }
        this._collectionNodeInfo = this.createCollectionNodeInfo();
        this.setSizeDirty(true);
    }

    public boolean isSizeDirty() {
        return this._sizeDirty;
    }

    public void setSizeDirty(boolean dirty) {
        LOG.log(Level.FINE, "{0} size dirty={1}", new Object[]{this._graphEntity, dirty});
        this._sizeDirty = dirty;
    }

    public void reinflate() {
        LOG.log(Level.FINE, "{0} reinflate", this._graphEntity);
        if (!this.isInflated()) {
            throw new IllegalStateException("Must be inflated");
        }
        try {
            if (this._entitySkeleton != null) {
                EntityID entityID = (EntityID)this._graphEntity.getID();
                EntitySkeletonProvider entitySkeletons = SkeletonProviders.entitiesForGraph((GraphID)this._graphEntity.getGraphID());
                entitySkeletons.removeEntitySkeleton(entityID);
                this._entitySkeleton = entitySkeletons.getEntitySkeleton(entityID);
            } else {
                this._collectionNodeInfo = this.createCollectionNodeInfo();
            }
            this.updateLabels();
            this.setSizeDirty(true);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private CollectionNodeRenderInfo createCollectionNodeInfo() {
        CollectionNodeRenderInfo info = null;
        try {
            EntityID viewEntityID = (EntityID)this._graphEntity.getID();
            GraphStoreView view = this.getGraphStoreView();
            GraphModelViewMappings mappings = view.getModelViewMappings();
            Set entities = mappings.getModelEntities(viewEntityID);
            EntityID firstModelEntity = (EntityID)entities.iterator().next();
            String type = view.getModel().getGraphDataStore().getDataStoreReader().getEntityType(firstModelEntity);
            CollectionNodeComponent component = CollectionNodeComponents.getComponent(this._graphEntity);
            info = new CollectionNodeRenderInfo(entities.size(), component, type);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return info;
    }

    public void updateLabels() {
        int labelCount = this.labelCount();
        LOG.log(Level.FINE, "{0} updateLabels ({1})", new Object[]{this._graphEntity, labelCount});
        if (labelCount > 0) {
            if (!this.isCollectionNode()) {
                EntityValueLabel label = (EntityValueLabel)this.getLabel();
                label.updateText();
            }
            boolean hovered = false;
            if (this._entitySkeleton != null || this._collectionNodeInfo != null) {
                GraphPart<? extends Guid> graphPart = HoverContext.forContextID("graph").getHoverViewPart();
                hovered = this._graphEntity.equals(graphPart);
                this.onPinUpdated(hovered);
            }
            if (this._entitySkeleton != null) {
                this.onNotesUpdated(this._entitySkeleton);
                this.onShowNotesUpdated(this._entitySkeleton.isShowNotes());
                this.onBookmarkUpdated(this._entitySkeleton.getBookmark(), hovered);
            }
            this.setSizeDirty(true);
        }
    }

    public void deflate() {
        this.removeAllLabels();
        this._entitySkeleton = null;
        this._collectionNodeInfo = null;
    }

    public int getPaintHash() {
        return this._paintHash;
    }

    private void onNotesUpdated(MaltegoEntity entitySkeleton) {
        NotesLabel notesEditLabel;
        gB notesLabel = this.getLabel(2);
        if (notesLabel != null) {
            String notes = entitySkeleton.getNotes();
            Color color = LAF.getColor("note-overlay-color");
            if (StringUtilities.isNullOrEmpty((String)notes)) {
                color = ColorUtil.setAlpha((Color)LAF.getColor("note-overlay-empty-color"), (int)Integer.decode((String)LAF.get("note-overlay-empty-aplha")));
            } else {
                notesLabel.setVisible(true);
            }
            notesLabel.setBackgroundColor(color);
        }
        if ((notesEditLabel = (NotesLabel)this.getLabel(4)) != null) {
            notesEditLabel.updateText(entitySkeleton);
        }
    }

    private void onShowNotesUpdated(boolean show) {
        gB notesEditLabel = this.getLabel(4);
        if (notesEditLabel != null) {
            notesEditLabel.setVisible(show);
        }
    }

    private void onBookmarkUpdated(int bookmark, boolean hovered) {
        gB notesEditLabel;
        gB bookmarkLabel = this.getLabel(3);
        if (bookmarkLabel != null) {
            NodeLabelUtils.setBookmark((X)bookmarkLabel, bookmark);
            bookmarkLabel.setVisible(bookmark >= 0 || hovered);
        }
        if ((notesEditLabel = this.getLabel(4)) != null) {
            NodeLabelUtils.setBookmark((X)notesEditLabel, bookmark);
        }
    }

    private void onPinUpdated(boolean hovered) {
        gB pinLabel = this.getLabel(1);
        if (pinLabel != null) {
            boolean visible = false;
            if (this._graphEntity != null) {
                boolean pinned;
                visible = this.isCollectionNode() ? hovered : (pinned = PinUtils.isPinned(this._graphEntity.getGraphID(), (EntityID)this._graphEntity.getID())) || hovered;
            }
            pinLabel.setVisible(visible);
        }
    }

    private static synchronized String getConfig() {
        if (_config == null) {
            _config = "LightweightEntityRealizer";
            HA._P factory = HA.getFactory();
            Map implementationsMap = factory.A();
            EntityNodeHotSpotPainter hsp = new EntityNodeHotSpotPainter();
            implementationsMap.put(HA._S.class, hsp);
            factory.A(_config, implementationsMap);
        }
        return _config;
    }

    public void removeAllLabels() {
        for (int i = this.labelCount() - 1; i >= 0; --i) {
            this.removeLabel(i);
        }
    }

    private void removeAllPorts() {
        for (int i = this.portCount() - 1; i >= 0; --i) {
            this.removePort(i);
        }
    }
}

