/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.util.EntityLimitNotifier;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class DefaultEntityLimitNotifier
implements EntityLimitNotifier {
    AtomicBoolean showDialog = new AtomicBoolean(false);

    public void notifyLimitExceeded() {
        if (this.showDialog.get()) {
            return;
        }
        Runnable asyncDialog = () -> this.asyncDialog();
        SwingUtilities.invokeLater(asyncDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncDialog() {
        LicenseManager licMan = LicenseManager.A();
        com.paterva.maltego.licensing.mode.A licenseMode = licMan.A(false);
        boolean licensed = licenseMode.B() || licenseMode.W();
        String sentenceText = licensed ? "upgrading" : "buying";
        String msg = "The current operation will cause the graph to exceed " + A.C((com.paterva.maltego.licensing.mode.A)licenseMode) + " entities, which is the maximum number of entities allowed in a graph on this Maltego Plan.\n\nPlease consider " + sentenceText + " your Maltego Plan to unlock more features.";
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
        nd.setMessageType(1);
        nd.setTitle("Graph Size Limit Reached");
        String upgradeOption = licensed ? "Upgrade" : "Buy";
        String cancelOption = "Cancel";
        Object[] options = new String[]{upgradeOption, cancelOption};
        nd.setOptions(options);
        try {
            this.showDialog.set(true);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (upgradeOption.equals(result)) {
                String licenseKey;
                String string = licenseKey = licenseMode.B() ? licMan.C() : null;
                if (licensed) {
                    BrowseToUrl.upgradePlan((String)licenseKey);
                } else {
                    BrowseToUrl.buyPlan((String)licenseKey);
                }
                ProductSelectionAction.perform();
            }
        }
        finally {
            this.showDialog.set(false);
        }
    }
}

