/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.ui.graph.actions.SelectionToggleAction;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.J.SA;

public class BookmarkUtils {
    public static void setBookmarkForSelection(GraphID graphID, int newBookmark) {
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        Set entityIDs = selection.getSelectedModelEntities();
        if (!entityIDs.isEmpty()) {
            Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID, (Collection)entityIDs);
            GraphTransactionHelper.doChangeBookmark(graphID, entities, newBookmark);
        }
    }

    public static void selectBookmarked(final TopComponent tc, GraphID graphID, int bookmark, boolean invert) {
        ZoomToSelectionAction zoomAction;
        Guid id;
        SA viewGraph = null;
        boolean normalZoomToSelection = true;
        GraphViewCookie cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class);
        if (cookie != null) {
            viewGraph = cookie.getGraphView().getViewGraph();
            normalZoomToSelection = false;
        } else if (graphID != null) {
            viewGraph = GraphViewManager.getDefault().getViewGraph(graphID);
        }
        if (viewGraph == null) {
            return;
        }
        if (SelectionMode.isLinks()) {
            ((SelectionToggleAction)SystemAction.get(SelectionToggleAction.class)).performAction();
        }
        Set<EntityID> toSelect = BookmarkUtils.selectBookmarked(viewGraph, bookmark, invert);
        if (!normalZoomToSelection && toSelect.size() == 1 && (id = (Guid)toSelect.iterator().next()) instanceof EntityID) {
            EntityID entityID = (EntityID)id;
            if (graphID != null) {
                try {
                    ZoomAndFlasher.instance().zoomAndFlash(graphID, entityID);
                    normalZoomToSelection = false;
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (normalZoomToSelection && (zoomAction = (ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)) != null) {
            zoomAction.zoomToSelection();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tc.requestActive();
            }
        });
    }

    public static Set<EntityID> selectBookmarked(SA viewGraph, int bookmark, boolean invert) {
        Set entities = GraphStoreHelper.getMaltegoEntities((D)viewGraph);
        HashSet<EntityID> toSelect = new HashSet<EntityID>();
        for (MaltegoEntity entity : entities) {
            boolean select;
            boolean bl = select = entity.getBookmark() == bookmark;
            if (invert) {
                boolean bl2 = select = !select;
            }
            if (!select) continue;
            toSelect.add((EntityID)entity.getID());
        }
        GraphSelection selection = GraphSelection.forGraph((GraphID)GraphIDProvider.forGraph((SA)viewGraph));
        selection.setSelectedModelEntities(toSelect);
        return toSelect;
    }
}

