/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.transform.protocol.api.EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.v3.api.V3TransformInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class V3EntitySpecTranslator
extends EntitySpecTranslator<V3TransformInfo> {
    private static V3EntitySpecTranslator instance;

    private V3EntitySpecTranslator() {
    }

    public static synchronized V3EntitySpecTranslator getDefault() {
        if (instance == null) {
            instance = new V3EntitySpecTranslator();
        }
        return instance;
    }

    public Set<MaltegoEntitySpec> getEntities(V3TransformInfo info) {
        Set<MaltegoEntitySpec> entities = V3EntitySpecTranslator.level1Registry().getAll().stream().map(entity -> new MaltegoEntitySpec(entity)).collect(Collectors.toSet());
        for (String entityType : info.getInputEntityTypes()) {
            MaltegoEntitySpec input = this.getEntity(entityType);
            if (input == null) continue;
            entities.add(input);
        }
        for (String output : info.getOutputEntityTypes()) {
            MaltegoEntitySpec spec = this.getEntity(output);
            if (spec == null) continue;
            entities.add(spec);
        }
        HashSet parents = new HashSet();
        for (MaltegoEntitySpec entity2 : entities) {
            parents.addAll(entity2.getBaseEntitySpecs());
        }
        for (String parent : parents) {
            MaltegoEntitySpec spec;
            if (parent == null || (spec = (MaltegoEntitySpec)V3EntitySpecTranslator.level2Registry().get(parent)) == null) continue;
            entities.add(spec);
        }
        return entities;
    }
}

