/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball.customization;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.view.customization.api.Customizable;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.J.SA;
import yguard.A.J.fA;
import yguard.A.J.q;

public class LinkThicknessCustomizable
extends Customizable.Edges {
    public static final int MIN = 1;
    public static final int MAX = 5;
    public static final int DEFAULT = 1;

    public String getName() {
        return "maltego.view.customizable.link.thickness";
    }

    public String getDisplayName() {
        return "Link Thickness";
    }

    public String getDescription() {
        return "The thickness of a link. Value is clamped to [1 - 5]. Default/fallback is 1.";
    }

    public boolean isViewSupported(String viewID) {
        return "BallView".equals(viewID);
    }

    public Class getValueType() {
        return Integer.class;
    }

    public void setDefault(H target) {
        this.setValue(target, (Object)null);
    }

    public Object getValue(H target) {
        MaltegoLink link = this.getLink(target);
        return link != null ? link.getThickness() : null;
    }

    public void setValue(H target, Object value) {
        SA graph2D;
        q realizer;
        D graph;
        int thickness = 1;
        if (value instanceof Number) {
            thickness = ((Number)value).intValue();
            thickness = Math.max(thickness, 1);
            thickness = Math.min(thickness, 5);
        }
        if ((graph = target.a()) instanceof SA && (realizer = (graph2D = (SA)graph).X(target)) != null) {
            realizer.setLineType(fA.B((int)thickness, (byte)realizer.getLineType().B()));
        }
    }

    private MaltegoLink getLink(H edge) {
        D graph = edge.a();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((D)graph);
        if (wrapper != null) {
            return wrapper.link(edge);
        }
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

