/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.StatusItem;
import com.paterva.maltego.transform.manager.nodes.TransformProperties;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class StatusItemNode
extends AbstractNode
implements CheckableNode {
    private boolean _checkable;

    protected StatusItemNode(Children children, StatusItem item, InstanceContent content, boolean checkable) {
        super(children, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)item);
        content.add((Object)this);
        this.setDisplayName(item.getDisplayName());
        this.setShortDescription(item.getDescription());
        this._checkable = checkable;
    }

    public String getHtmlDisplayName() {
        return ((StatusItem)this.getLookup().lookup(StatusItem.class)).getHtmlDisplayName();
    }

    public boolean isCheckable() {
        return this._checkable;
    }

    public boolean isCheckEnabled() {
        return true;
    }

    public Boolean isSelected() {
        return ((StatusItem)this.getLookup().lookup(StatusItem.class)).isEnabled();
    }

    public void setSelected(Boolean value) {
        Boolean oldValue = this.isSelected();
        if (!Utilities.compareObjects((Object)oldValue, (Object)value)) {
            ((StatusItem)this.getLookup().lookup(StatusItem.class)).setEnabled(value.booleanValue());
            this.firePropertyChange("status", oldValue, value);
            this.onEnabledChange(value);
        }
    }

    public void setCheckable(boolean checkable) {
        this._checkable = checkable;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new TransformProperties.Description((Node)this));
        set.put((Node.Property)new TransformProperties.Status((Node)this));
        sheet.put(set);
        return sheet;
    }

    protected void onEnabledChange(boolean enabled) {
    }

    public Status getStatus() {
        return ((StatusItem)this.getLookup().lookup(StatusItem.class)).getStatus();
    }
}

