/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.seeds;

import com.paterva.maltego.importexport.ConfigNode;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.manager.imex.seeds.SeedConfig;
import com.paterva.maltego.transform.manager.imex.seeds.SeedExistInfo;
import java.awt.Image;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class SeedNode
extends ConfigNode {
    private SeedConfig _config;

    public SeedNode(SeedConfig config, TransformSeed seed, SeedExistInfo existInfo) {
        this(seed, new InstanceContent(), existInfo);
        this._config = config;
    }

    private SeedNode(TransformSeed seed, InstanceContent content, SeedExistInfo existInfo) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)seed);
        content.add((Object)this);
        String displayName = seed.getDisplayName();
        if (existInfo != null && existInfo.exist(seed)) {
            displayName = "<exist> " + displayName;
        }
        this.setDisplayName(displayName);
        this.setShortDescription(seed.getUrl().toString());
    }

    public void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            TransformSeed seed = (TransformSeed)this.getLookup().lookup(TransformSeed.class);
            if (selected.booleanValue()) {
                this._config.select(seed);
            } else {
                this._config.unselect(seed);
            }
        }
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png");
    }
}

