/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.finder.wizard.DuplicateTransformsInstalledPanel;
import com.paterva.maltego.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.openide.util.NbBundle;

public class UpdateFetchPanel
extends JPanel {
    private final DuplicateTransformsInstalledPanel _duplicateTxPanel = new DuplicateTransformsInstalledPanel();
    private JLabel _statusLabel;
    private JTextArea _text;
    private JLabel _titleLabel;
    private JPanel jPanel1;

    public UpdateFetchPanel() {
        this.initComponents();
        this.add((Component)this._duplicateTxPanel, "South");
    }

    public void setNoSeeds() {
        this._titleLabel.setText("Transform Installation");
        this._statusLabel.setVisible(false);
        this._text.setText("No Transform Servers were selected to install tranforms from, but this is not a problem, Transforms can be installed later at any time using the Maltego Data Hub.");
        this._text.setLineWrap(true);
        this._text.setWrapStyleWord(true);
        this._duplicateTxPanel.setVisible(false);
    }

    public void setText(String text) {
        this._titleLabel.setText("Complete");
        if (StringUtilities.isNullOrEmpty((String)text)) {
            this._statusLabel.setText("All items are up-to-date.");
        } else {
            this._statusLabel.setText("The following items were downloaded:");
        }
        this._text.setText(text);
    }

    public void setDuplicateTransforms(Map<HubSeedDescriptor, Set<TransformDescriptor>> transforms) {
        if (transforms.isEmpty()) {
            this._duplicateTxPanel.setVisible(false);
        } else {
            this._duplicateTxPanel.setDuplicateTransforms(transforms);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._titleLabel = new JLabel();
        this._statusLabel = new JLabel();
        this._text = new JTextArea();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 6));
        this.setMaximumSize(new Dimension(10, 10));
        this.setPreferredSize(new Dimension(10, 10));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this._titleLabel.setFont(this._titleLabel.getFont().deriveFont(this._titleLabel.getFont().getStyle() | 1, this._titleLabel.getFont().getSize() + 1));
        this._titleLabel.setText(NbBundle.getMessage(UpdateFetchPanel.class, (String)"UpdateFetchPanel._titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this._titleLabel, gridBagConstraints);
        this._statusLabel.setText(NbBundle.getMessage(UpdateFetchPanel.class, (String)"UpdateFetchPanel._statusLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this._statusLabel, gridBagConstraints);
        this._text.setEditable(false);
        this._text.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel1.add((Component)this._text, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
    }
}

