/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.ui.imex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.tx.inputs.global.registry.DefaultGlobalTransformInputsRepository;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInput;
import com.paterva.maltego.tx.inputs.global.ui.imex.GlobalInputsConfig;
import com.paterva.maltego.tx.inputs.global.ui.imex.GlobalInputsExistInfo;
import com.paterva.maltego.tx.inputs.global.ui.imex.GlobalInputsImporter;
import com.paterva.maltego.tx.inputs.global.ui.imex.SelectableGlobalInput;
import com.paterva.maltego.tx.inputs.global.ui.imex.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openide.filesystems.FileObject;

public class GlobalInputsConfigImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        GlobalInputsImporter importer = new GlobalInputsImporter();
        List<GlobalTransformInput> inputs = importer.read(reader);
        return this.createConfig(inputs);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        DefaultGlobalTransformInputsRepository registry = new DefaultGlobalTransformInputsRepository(configRoot);
        ArrayList<GlobalTransformInput> inputs = new ArrayList<GlobalTransformInput>(registry.getAll());
        return this.createConfig(inputs);
    }

    private Config createConfig(List<GlobalTransformInput> inputs) {
        if (inputs.isEmpty()) {
            return null;
        }
        List<SelectableGlobalInput> selectables = Util.createSelectables(inputs);
        GlobalInputsExistInfo existInfo = new GlobalInputsExistInfo();
        for (SelectableGlobalInput selectable : selectables) {
            selectable.setSelected(!existInfo.exist(selectable.getGlobalInput()));
        }
        return new GlobalInputsConfig(selectables);
    }

    public int applyConfig(Config config) {
        GlobalInputsImporter importer = new GlobalInputsImporter();
        GlobalInputsConfig inputConfig = (GlobalInputsConfig)config;
        HashSet<GlobalTransformInput> inputs = new HashSet<GlobalTransformInput>();
        for (SelectableGlobalInput selectable : inputConfig.getSelectedGlobalInputs()) {
            inputs.add(selectable.getGlobalInput());
        }
        return importer.apply(inputs);
    }
}

