/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.fullscreen;

import com.paterva.maltego.detailview.DetailViewTopComponent;
import com.paterva.maltego.util.ui.Direction;
import com.paterva.maltego.util.ui.slide.SlideCallback;
import com.paterva.maltego.util.ui.slide.SlideWindow;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.openide.windows.WindowManager;

public class SlideWindowDetailView
extends DetailViewTopComponent
implements SlideWindow {
    private static final String PREFERRED_ID = "SlideWindowDetailView";
    private List<SlideCallback> _callbacks = new ArrayList<SlideCallback>();

    public String getSlideWindowName() {
        return "Detail View";
    }

    @Override
    protected String preferredID() {
        return PREFERRED_ID;
    }

    @Override
    public int getPersistenceType() {
        return 2;
    }

    public JComponent getComponent() {
        return this;
    }

    public Rectangle getDefaultBounds() {
        Rectangle screenBounds = WindowManager.getDefault().getMainWindow().getGraphicsConfiguration().getBounds();
        return new Rectangle(screenBounds.width, 250, 400, 400);
    }

    public Direction getDefaultDirection() {
        return Direction.EAST;
    }

    public void opened() {
        this.componentOpened();
    }

    public void closed() {
        this.componentClosed();
    }

    public void activated() {
        this.componentActivated();
    }

    public void deactivated() {
        this.componentDeactivated();
    }

    public void addSlideCallback(SlideCallback callback) {
        this._callbacks.add(callback);
    }

    public void removeSlideCallback(SlideCallback callback) {
        this._callbacks.remove(callback);
    }

    private void fireSlideOut() {
        for (SlideCallback callback : this._callbacks) {
            callback.slideOut();
        }
    }

    private void fireSlideIn() {
        for (SlideCallback callback : this._callbacks) {
            callback.slideIn();
        }
    }

    @Override
    protected void onShowEmpty() {
        this.fireSlideIn();
    }

    @Override
    protected void onShowHover() {
        this.fireSlideOut();
    }

    @Override
    protected void onShowSelection(boolean singleSelection) {
        if (singleSelection) {
            this.fireSlideOut();
        } else {
            this.fireSlideIn();
        }
    }
}

