/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import com.paterva.maltego.util.BulkStatusDisplayer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CollectionNodesSerializer {
    private static final Logger LOG = Logger.getLogger(CollectionNodesSerializer.class.getName());
    private static final int VERSION = 2;
    private final GraphID _graphID;
    private Map<EntityID, ViewEntity> _loadedViewEntities;
    private Map<LinkID, ViewLink> _loadedViewLinks;
    private boolean _synced = false;

    private CollectionNodesSerializer(GraphID graphID) {
        this._graphID = graphID;
    }

    public static synchronized CollectionNodesSerializer getInstance(GraphID graphID) {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        CollectionNodesSerializer serializer = (CollectionNodesSerializer)gud.get((Object)(key = CollectionNodesSerializer.class.getName()));
        if (serializer == null) {
            serializer = new CollectionNodesSerializer(graphID);
            gud.put((Object)key, (Object)serializer);
        }
        return serializer;
    }

    public void reset() {
        this._loadedViewEntities = null;
        this._loadedViewLinks = null;
    }

    public void write(InMemoryCollectionNodes collectionNodes, OutputStream os) throws IOException {
        Map<EntityID, ViewEntity> viewEntities = collectionNodes.getViewEntities();
        Map<LinkID, ViewLink> viewLinks = collectionNodes.getViewLinks();
        this.writeCache(viewEntities, viewLinks, os);
    }

    public void load(InputStream is) throws IOException {
        this.loadCache(is);
    }

    public boolean isSynced() {
        return this._synced;
    }

    public void setSynced(boolean synced) {
        this._synced = synced;
    }

    Map<EntityID, ViewEntity> getLoadedViewEntities() {
        return this._loadedViewEntities;
    }

    Map<LinkID, ViewLink> getLoadedViewLinks() {
        return this._loadedViewLinks;
    }

    private void loadCache(InputStream is) {
        DataInputStream dis = new DataInputStream(is);
        try {
            if (dis.readInt() != 2) {
                LOG.log(Level.FINE, "MTGL collection-node version mismatch, cannot load collection, will need to recollect");
                return;
            }
            boolean canSyncDirectly = this.loadSettings(dis);
            if (canSyncDirectly) {
                this.loadEntities(dis);
                this.loadLinks(dis);
                this.setSynced(true);
            }
        }
        catch (IOException ex) {
            if (this._loadedViewEntities != null) {
                this._loadedViewEntities.clear();
            }
            if (this._loadedViewLinks != null) {
                this._loadedViewLinks.clear();
            }
            this.setSynced(false);
            LOG.log(Level.WARNING, "Failed to load collection node cache, will have to recalculate the collections");
        }
    }

    private boolean loadSettings(DataInputStream dis) throws IOException {
        boolean isEnabled = dis.readBoolean();
        int minRequiredEntitiesPerNode = dis.readInt();
        double ruleRatio = dis.readDouble();
        CollectionSettings.getDefault().setEnabled(this._graphID, isEnabled);
        CollectionSettings.getDefault().setMinRequiredEntitiesPerNode(this._graphID, minRequiredEntitiesPerNode);
        if (ruleRatio == CollectionSettings.getDefault().getRuleRatio()) {
            LOG.log(Level.FINE, "Can sync directly");
            return isEnabled;
        }
        LOG.log(Level.FINE, "Can NOT sync directly");
        return false;
    }

    private void loadEntities(DataInputStream dis) throws IOException {
        int amountOfViewEntities = dis.readInt();
        BulkStatusDisplayer status = new BulkStatusDisplayer("Loading collections (%d/" + amountOfViewEntities + ")");
        this._loadedViewEntities = new HashMap<EntityID, ViewEntity>(amountOfViewEntities);
        for (int i = 0; i < amountOfViewEntities; ++i) {
            status.increment();
            this.readEntityEntry(dis);
        }
        status.clear();
    }

    private void readEntityEntry(DataInputStream dis) throws IOException {
        EntityID entity = EntityID.create((long)dis.readLong());
        int typeStrLength = dis.readInt();
        byte[] typeStrBuffer = new byte[typeStrLength];
        dis.readFully(typeStrBuffer);
        String type = new String(typeStrBuffer, StandardCharsets.UTF_8);
        int collectionSize = dis.readInt();
        LinkedList<EntityID> collectionList = new LinkedList<EntityID>();
        for (int i = 0; i < collectionSize; ++i) {
            collectionList.add(EntityID.create((long)dis.readLong()));
        }
        HashSet<EntityID> collection = new HashSet<EntityID>(collectionList);
        Set<LinkID> modelIncoming = this.readLinks(dis);
        Set<LinkID> modelOutgoing = this.readLinks(dis);
        Set<LinkID> viewIncoming = this.readLinks(dis);
        Set<LinkID> viewOutgoing = this.readLinks(dis);
        ViewEntity viewEntity = new ViewEntity(type, collection, new EntityLinks(modelIncoming, modelOutgoing, viewIncoming, viewOutgoing));
        this._loadedViewEntities.put(entity, viewEntity);
    }

    Set<LinkID> readLinks(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        LinkedList<LinkID> linksList = new LinkedList<LinkID>();
        for (int i = 0; i < size; ++i) {
            linksList.add(LinkID.create((long)dis.readLong()));
        }
        return new HashSet<LinkID>(linksList);
    }

    private void loadLinks(DataInputStream dis) throws IOException {
        int amountOfViewLinks = dis.readInt();
        this._loadedViewLinks = new HashMap<LinkID, ViewLink>(amountOfViewLinks);
        for (int i = 0; i < amountOfViewLinks; ++i) {
            this.readLinkEntry(dis);
        }
    }

    private void readLinkEntry(DataInputStream dis) throws IOException {
        LinkID linkID = LinkID.create((long)dis.readLong());
        LinkEntityIDs ids = new LinkEntityIDs(EntityID.create((long)dis.readLong()), EntityID.create((long)dis.readLong()));
        int collectionSize = dis.readInt();
        LinkedList<LinkID> collectionList = new LinkedList<LinkID>();
        for (int i = 0; i < collectionSize; ++i) {
            collectionList.add(LinkID.create((long)dis.readLong()));
        }
        HashSet<LinkID> collection = new HashSet<LinkID>(collectionList);
        ViewLink viewLink = new ViewLink(ids, collection);
        this._loadedViewLinks.put(linkID, viewLink);
    }

    private void writeCache(Map<EntityID, ViewEntity> viewEntities, Map<LinkID, ViewLink> viewLinks, OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(2);
        this.saveSettings(dos);
        this.saveEntities(viewEntities, dos);
        this.saveLinks(viewLinks, dos);
    }

    private void saveSettings(DataOutputStream dos) throws IOException {
        dos.writeBoolean(CollectionSettings.getDefault().isEnabled(this._graphID));
        dos.writeInt(CollectionSettings.getDefault().getMinRequiredEntitiesPerNode(this._graphID));
        dos.writeDouble(CollectionSettings.getDefault().getRuleRatio());
    }

    private void saveEntities(Map<EntityID, ViewEntity> viewEntities, DataOutputStream dos) throws IOException {
        dos.writeInt(viewEntities.size());
        for (Map.Entry<EntityID, ViewEntity> entry : viewEntities.entrySet()) {
            EntityID entity = entry.getKey();
            ViewEntity viewEntity = entry.getValue();
            this.writeEntityEntry(dos, entity, viewEntity);
        }
    }

    private void writeEntityEntry(DataOutputStream dos, EntityID entity, ViewEntity viewEntity) throws IOException {
        dos.writeLong(entity.getValue());
        byte[] bytes = viewEntity.getType().getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        dos.writeInt(length);
        dos.write(bytes);
        Set<EntityID> collection = viewEntity.getCollection();
        dos.writeInt(collection.size());
        for (EntityID entityID : collection) {
            dos.writeLong(entityID.getValue());
        }
        EntityLinks links = viewEntity.getAllLinks();
        Set<LinkID> modelIncoming = links.getModelIncomingLinks();
        Set<LinkID> modelOutgoing = links.getModelOutgoingLinks();
        Set<LinkID> viewIncoming = links.getViewIncomingLinks();
        Set<LinkID> viewOutgoing = links.getViewOutgoingLinks();
        this.writeEntityLinks(dos, modelIncoming);
        this.writeEntityLinks(dos, modelOutgoing);
        this.writeEntityLinks(dos, viewIncoming);
        this.writeEntityLinks(dos, viewOutgoing);
    }

    private void writeEntityLinks(DataOutputStream dos, Set<LinkID> links) throws IOException {
        dos.writeInt(links.size());
        for (LinkID link : links) {
            dos.writeLong(link.getValue());
        }
    }

    private void saveLinks(Map<LinkID, ViewLink> viewLinks, DataOutputStream dos) throws IOException {
        dos.writeInt(viewLinks.size());
        for (Map.Entry<LinkID, ViewLink> entry : viewLinks.entrySet()) {
            LinkID link = entry.getKey();
            ViewLink viewLink = entry.getValue();
            this.writeLinkEntry(dos, link, viewLink);
        }
    }

    private void writeLinkEntry(DataOutputStream dos, LinkID link, ViewLink viewLink) throws IOException {
        LinkEntityIDs ids = viewLink.getEntities();
        Set<LinkID> collection = viewLink.getCollection();
        dos.writeLong(link.getValue());
        dos.writeLong(ids.getSourceID().getValue());
        dos.writeLong(ids.getTargetID().getValue());
        dos.writeInt(collection.size());
        for (LinkID linkID : collection) {
            dos.writeLong(linkID.getValue());
        }
    }
}

