/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre;

import com.paterva.maltego.java.config.jre.DetectJavas;
import com.paterva.maltego.java.config.jre.ExecutionResults;
import com.paterva.maltego.java.config.jre.FileProxy;
import com.paterva.maltego.java.config.jre.JavaInfo;
import com.paterva.maltego.java.config.jre.LogManager;
import com.paterva.maltego.java.config.jre.SystemUtils;
import com.paterva.maltego.java.config.jre.Version;
import com.paterva.maltego.java.config.jre.mac.MacDetectJava;
import com.paterva.maltego.java.config.jre.unix.UnixDetectJava;
import com.paterva.maltego.java.config.jre.windows.WinDetectJava;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class JavaUtils {
    public static final int TEST_JDK_OUTPUT_PARAMETERS = 5;
    public static final String NON_FINAL_JVM_PATTERN = "-(ea|rc[0-9]*|beta[0-9]*|preview[0-9]*|dp[0-9]*|alpha[0-9]*|fcs)";
    private static Map<String, JavaInfo> _javas;

    public static synchronized Map<String, JavaInfo> detectJavas() {
        if (_javas == null) {
            DetectJavas detector = SystemUtils.isWindows() ? new WinDetectJava() : (SystemUtils.isUnix() ? new UnixDetectJava() : new MacDetectJava());
            _javas = detector.detectJavas();
        }
        return _javas;
    }

    public static boolean isJavaHome(File javaHome) {
        if (!javaHome.exists()) {
            System.out.println("does not exist: " + javaHome);
            return false;
        }
        if (!javaHome.isDirectory()) {
            System.out.println("not a directory: " + javaHome);
            return false;
        }
        File probe = JavaUtils.getExecutable(javaHome);
        if (!probe.exists()) {
            System.out.println("does not exist: " + probe);
            return false;
        }
        if (!probe.isFile()) {
            System.out.println("not a file: " + probe);
            return false;
        }
        probe = new File(javaHome, "lib");
        if (!probe.exists()) {
            System.out.println("does not exist: " + probe);
            return false;
        }
        if (!probe.isDirectory()) {
            System.out.println("not a directory: " + probe);
            return false;
        }
        return true;
    }

    public static JavaInfo getInfo(File javaHome) {
        File location = javaHome;
        try {
            location = javaHome.getCanonicalFile();
            System.out.println("canonical: " + location);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!JavaUtils.isJavaHome(location)) {
            return null;
        }
        System.out.println("javaHome: " + javaHome);
        File executable = JavaUtils.getExecutable(location);
        File testJdk = FileProxy.getFile("resource:com/paterva/maltego/java/config/jre/TestJDK.class");
        if (testJdk == null) {
            return null;
        }
        JavaInfo jdkInfo = null;
        try {
            ExecutionResults results = SystemUtils.executeCommand(false, executable.getAbsolutePath(), "-classpath", testJdk.getParentFile().getAbsolutePath(), "TestJDK");
            jdkInfo = JavaInfo.getInfo(results.getStdOut(), false);
            if (jdkInfo == null) {
                System.out.println(" can`t get jdkInfo from " + location);
            }
        }
        catch (IOException e) {
            LogManager.log("Failed to execute the JDK verification procedure", e);
        }
        return jdkInfo;
    }

    public static File getExecutable(File javaHome) {
        if (SystemUtils.isWindows()) {
            return new File(javaHome, "bin/java.exe");
        }
        return new File(javaHome, "bin/java");
    }

    public static boolean isValidVersion(Version version) {
        long major = version.getMajor();
        long minor = version.getMinor();
        return major == 1L && minor >= 8L || major >= 9L;
    }
}

