/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.MaltegoPartSpec;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.util.ListMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.Utilities;

public class MaltegoEntitySpec
extends MaltegoPartSpec<EntityID, MaltegoEntity> {
    public static final String ROOT_ENTITY_SPEC = "maltego.Unknown";
    private int conversionOrder = Integer.MAX_VALUE;
    private List<String> baseEntitySpecs;
    private EntityConverter converter;
    private OverlayDescriptorSet overlaySet;
    private String imageExpression;

    public MaltegoEntitySpec() {
    }

    public MaltegoEntitySpec(String name, DisplayDescriptorCollection properties) {
        super(name, properties);
    }

    public MaltegoEntitySpec(String name, DisplayDescriptorCollection properties, GroupDefinitions groups) {
        super(name, properties, groups);
    }

    public MaltegoEntitySpec(String name, PropertyConfiguration properties) {
        super(name, properties);
    }

    public MaltegoEntitySpec(MaltegoEntitySpec other) {
        super(other);
        this.conversionOrder = other.getConversionOrder();
        this.baseEntitySpecs = new ArrayList<String>(other.getBaseEntitySpecs());
        this.converter = other.getConverter();
        OverlayDescriptorSet otherOverlays = other.getOverlaySet();
        this.overlaySet = otherOverlays == null ? new OverlayDescriptorSet() : new OverlayDescriptorSet((Collection)otherOverlays);
        this.imageExpression = other.getImageExpression().orElse(null);
    }

    @Override
    public boolean isCopy(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaltegoEntitySpec)) {
            return false;
        }
        MaltegoEntitySpec other = (MaltegoEntitySpec)((Object)obj);
        if (this.getConversionOrder() != other.getConversionOrder()) {
            return false;
        }
        if (this.getBaseEntitySpecs().size() != other.getBaseEntitySpecs().size()) {
            return false;
        }
        if (!Objects.equals(this.imageExpression, other.imageExpression)) {
            return false;
        }
        for (int i = 0; i < this.getBaseEntitySpecs().size(); ++i) {
            if (Utilities.compareObjects((Object)this.getBaseEntitySpecs().get(i), (Object)other.getBaseEntitySpecs().get(i))) continue;
            return false;
        }
        if (!Objects.equals(this.overlaySet, other.overlaySet)) {
            return false;
        }
        return super.isCopy((Object)other);
    }

    @Override
    public List<String> getBaseEntitySpecs() {
        if (this.baseEntitySpecs == null) {
            this.initBaseEntitySpecs();
        }
        return Collections.unmodifiableList(this.baseEntitySpecs);
    }

    public void setBaseEntitySpecs(List<String> baseEntitySpecs) {
        if (!this.getTypeName().equals(ROOT_ENTITY_SPEC)) {
            if (baseEntitySpecs == null || baseEntitySpecs.isEmpty()) {
                this.initBaseEntitySpecs();
            } else {
                this.baseEntitySpecs = baseEntitySpecs;
            }
        }
    }

    private void initBaseEntitySpecs() {
        this.baseEntitySpecs = new ArrayList<String>();
        if (!this.getTypeName().equals(ROOT_ENTITY_SPEC)) {
            this.baseEntitySpecs.add(ROOT_ENTITY_SPEC);
        }
    }

    public void setImageExpression(String imgExpr) {
        if (StringUtils.isBlank((CharSequence)imgExpr)) {
            imgExpr = null;
        }
        this.imageExpression = imgExpr;
    }

    public Optional<String> getImageExpression() {
        return Optional.ofNullable(this.imageExpression);
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.getTypeName() != null ? this.getTypeName().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MaltegoEntitySpec other = (MaltegoEntitySpec)((Object)obj);
        return !(this.getTypeName() != null ? !this.getTypeName().equals(other.getTypeName()) : other.getTypeName() != null);
    }

    public <ID extends Guid, T extends MaltegoPart<ID>> boolean equals(MaltegoPartSpec<ID, T> spec) {
        return spec.getTypeName().equals(this.getTypeName());
    }

    public EntityConverter getConverter() {
        return this.converter;
    }

    public void setConverter(EntityConverter entityConverter) {
        this.converter = entityConverter;
    }

    public int getConversionOrder() {
        return this.conversionOrder;
    }

    public void setConversionOrder(int matchingOrder) {
        this.conversionOrder = matchingOrder;
    }

    public void mergeWith(MaltegoEntitySpec other) {
        DisplayDescriptorCollection properties = this.getProperties();
        DisplayDescriptorCollection otherProperties = other.getProperties();
        for (DisplayDescriptor otherProperty : otherProperties) {
            if (otherProperty == null || properties.contains(otherProperty)) continue;
            properties.add(otherProperty);
        }
        if (other._specialProperties == null || other._specialProperties.isEmpty()) {
            return;
        }
        ListMap mergeSpecial = new ListMap();
        mergeSpecial.putAll((Map)other._specialProperties);
        if (this._specialProperties != null) {
            mergeSpecial.putAll((Map)this._specialProperties);
        }
        this._specialProperties = mergeSpecial;
        if (this.imageExpression == null) {
            this.imageExpression = other.imageExpression;
        }
        if (other.overlaySet != null) {
            if (this.overlaySet == null) {
                this.overlaySet = new OverlayDescriptorSet((Collection)other.overlaySet);
            } else {
                this.overlaySet.addAll((Collection)other.overlaySet);
            }
        }
    }

    public OverlayDescriptorSet getOverlaySet() {
        return this.overlaySet;
    }

    public void setOverlaySet(OverlayDescriptorSet overlaySet) {
        this.overlaySet = overlaySet;
    }
}

