/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openide.util.Lookup;

public abstract class TransformRequestProcessor {
    public static TransformRequestProcessor getDefault() {
        TransformRequestProcessor manager = (TransformRequestProcessor)Lookup.getDefault().lookup(TransformRequestProcessor.class);
        if (manager == null) {
            manager = new TrivialTransformRequestProcessor();
        }
        return manager;
    }

    public void runTransform(TransformDefinition transform, TransformServerInfo server, GraphID graphID, Set<EntityID> entities, TransformRunOrigin runOrigin) {
        this.runTransforms(Collections.singleton(transform), server, graphID, entities, false, runOrigin);
    }

    public abstract void runTransforms(Collection<? extends TransformDefinition> var1, TransformServerInfo var2, GraphID var3, Set<EntityID> var4, boolean var5, TransformRunOrigin var6);

    public void runTransforms(Collection<? extends TransformDefinition> transform, GraphID graphID, Set<EntityID> entities, boolean runAll, TransformRunOrigin runOrigin) {
        this.runTransforms(transform, null, graphID, entities, runAll, runOrigin);
    }

    public void runTransform(TransformDefinition transform, TransformRunOrigin runOrigin) {
        this.runTransform(transform, null, null, null, runOrigin);
    }

    public void runTransforms(Collection<TransformDefinition> transform, boolean runAll, TransformRunOrigin runOrigin) {
        this.runTransforms(transform, null, null, runAll, runOrigin);
    }

    private static class TrivialTransformRequestProcessor
    extends TransformRequestProcessor {
        private TrivialTransformRequestProcessor() {
        }

        @Override
        public void runTransforms(Collection<? extends TransformDefinition> transform, TransformServerInfo server, GraphID graphID, Set<EntityID> entities, boolean runAll, TransformRunOrigin runOrigin) {
            throw new UnsupportedOperationException("No TransformRequestProcessor registered");
        }
    }
}

