/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageContainer;
import com.paterva.maltego.imgfactory.impl.ImageID;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

class ImageDiskCache
implements ImageContainer {
    private final HashMap<ImageID, String> _cacheIndex = new HashMap();
    private File _cacheDir;

    public ImageDiskCache() {
        this.createCacheDir();
        this.clear();
    }

    @Override
    public boolean contains(ImageID imageId) {
        String filename = this._cacheIndex.get(imageId);
        if (filename != null) {
            File file = new File(this._cacheDir, filename);
            if (file.exists()) {
                return true;
            }
            this._cacheIndex.remove(imageId);
            this.verifyCache();
            return false;
        }
        return false;
    }

    @Override
    public Image get(ImageID imageId) {
        this.verifyCache();
        File file = new File(this._cacheDir, this._cacheIndex.get(imageId));
        BufferedImage image = null;
        try {
            image = ImageIO.read(file);
        }
        catch (Exception ex) {
            Logger.getLogger(ImageDiskCache.class.getName()).log(Level.SEVERE, null, ex);
        }
        return image;
    }

    @Override
    public void put(ImageID imageId, Image image) {
        this.verifyCache();
        try {
            this._cacheDir.mkdirs();
            File temp = File.createTempFile("temp", ".png", this._cacheDir);
            ImageDiskCache.writeImageToFile(image, temp);
            this._cacheIndex.put(imageId, temp.getName());
        }
        catch (IOException ex) {
            Logger.getLogger(ImageDiskCache.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void remove(ImageID imageId, boolean anySize) {
        if (!anySize) {
            String fileName = this._cacheIndex.get(imageId);
            if (fileName != null) {
                this.removeFile(fileName);
                this._cacheIndex.remove(imageId);
            }
        } else {
            Iterator<Map.Entry<ImageID, String>> it = this._cacheIndex.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ImageID, String> entry = it.next();
                if (!entry.getKey().Key.equals(imageId.Key)) continue;
                this.removeFile(entry.getValue());
                it.remove();
            }
        }
    }

    private void removeFile(String fileName) {
        File file = new File(this._cacheDir, fileName);
        if (!file.delete()) {
            Logger.getLogger(ImageDiskCache.class.getName()).log(Level.SEVERE, null, "Failed to delete " + file);
        }
    }

    @Override
    public final void clear() {
        File[] files;
        this._cacheIndex.clear();
        for (File file : files = this._cacheDir.listFiles()) {
            if (file.delete()) continue;
            Logger.getLogger(ImageDiskCache.class.getName()).log(Level.SEVERE, null, "Failed to delete " + file);
        }
    }

    @Override
    public int size() {
        return this._cacheIndex.size();
    }

    private void createCacheDir() {
        this._cacheDir = FileUtilities.createTempDir((String)"ImageCache");
    }

    private static void writeImageToFile(Image image, File file) throws IOException {
        ImageIO.write((RenderedImage)ImageUtils.createBufferedImage((Image)image), "png", file);
    }

    private void verifyCache() {
        if (!this._cacheDir.exists()) {
            this.createCacheDir();
            this._cacheIndex.clear();
        }
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder("Disk cache\n");
        sb.append("   Images = ");
        sb.append(this._cacheIndex.size());
        return sb.toString();
    }
}

