/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;

public class UnionAssumption
implements Assumption {
    private final String name;
    private final Assumption first;
    private final Assumption second;

    public UnionAssumption(String name, Assumption first, Assumption second) {
        this.name = name;
        this.first = first;
        this.second = second;
    }

    public UnionAssumption(Assumption first, Assumption second) {
        this(null, first, second);
    }

    @Override
    public void check() throws InvalidAssumptionException {
        this.first.check();
        this.second.check();
    }

    @Override
    public void invalidate() {
        this.first.invalidate();
        this.second.invalidate();
    }

    @Override
    public void invalidate(String message) {
        this.first.invalidate(message);
        this.second.invalidate(message);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.first.isValid() && this.second.isValid();
    }
}

