/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.oauth;

import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.paterva.maltego.pws.oauth.OAuthHttpUtils;
import com.paterva.maltego.pws.oauth.OAuthModel;
import com.paterva.maltego.pws.oauth.OAuthSignInCallback;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.NormalException;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class OAuthAuthenticatorService {
    private static final Logger LOG = Logger.getLogger(OAuthAuthenticatorService.class.getName());
    private static final String KEYSTORE_FILE_NAME = "com/paterva/maltego/pws/oauth/KeyStore.jks";
    private static final String SUCCESS_IMG = "/successImg";
    private final OAuthModel _model;
    private OAuth1RequestToken _requestToken;
    private Long _requestTime;
    private HttpServer _server;
    private OAuthSignInCallback _cb;

    public OAuthAuthenticatorService(OAuthModel model) {
        this._model = model;
    }

    public void signIn(OAuthSignInCallback callback) {
        this._cb = callback;
        try {
            LOG.log(Level.FINE, "Start server, url: http{0}://localhost:{1}", new Object[]{this._model.useSSLHost() ? "s" : "", Integer.toString(this._model.getPort())});
            this._server = this.createServer(this._model.useSSLHost());
            this._server.createContext("/" + this._model.getSigninContextName(), new SigninServlet());
            this._server.createContext("/" + this._model.getCallbackContextName(), new CallbackServlet());
            this._server.createContext("/" + this._model.getSuccessContextName(), new SuccessServlet());
            this._server.createContext(SUCCESS_IMG, new SuccessImgServlet());
            this._server.start();
            URL url = new URL(this._model.getServletUrl(this._model.getSigninContextName()));
            if (!FileUtilities.isRemoteFileURL((URL)url)) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        }
        catch (Exception ex) {
            this.stop();
            callback.failed(ex);
        }
    }

    public void cancel() {
        this.stop();
    }

    private void stop() {
        try {
            if (this._server != null) {
                try {
                    this._server.stop(3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this._server = null;
            this._cb = null;
        }
    }

    public Long getExpiresAtTime() {
        return this._requestTime;
    }

    protected void setRequestTime() {
        this._requestTime = System.currentTimeMillis();
    }

    protected void adjustExpiryTime(Integer expiresInSeconds) {
        this._requestTime = expiresInSeconds == null ? null : Long.valueOf(this._requestTime + (long)(expiresInSeconds * 1000));
    }

    private HttpServer createServer(boolean https) throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        HttpServer server;
        InetSocketAddress address = new InetSocketAddress(this._model.getPort());
        if (!https) {
            server = HttpServer.create(address, 0);
        } else {
            HttpsServer httpsServer = HttpsServer.create(address, 0);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            char[] password = "123456".toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            URL resource = this.getClass().getClassLoader().getResource(KEYSTORE_FILE_NAME);
            InputStream is = resource.openStream();
            ks.load(is, password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                @Override
                public void configure(HttpsParameters params) {
                    try {
                        SSLContext context = SSLContext.getDefault();
                        SSLEngine engine = context.createSSLEngine();
                        params.setNeedClientAuth(false);
                        params.setCipherSuites(engine.getEnabledCipherSuites());
                        params.setProtocols(engine.getEnabledProtocols());
                        SSLParameters sslParameters = context.getDefaultSSLParameters();
                        params.setSSLParameters(sslParameters);
                    }
                    catch (Exception ex) {
                        System.out.println("Failed to create HTTPS port");
                    }
                }
            });
            httpsServer.setExecutor(null);
            server = httpsServer;
        }
        return server;
    }

    private void sendOkResponse(HttpExchange he, String body) throws IOException {
        he.sendResponseHeaders(200, 0L);
        try (OutputStream stream = he.getResponseBody();){
            stream.write(body.getBytes(StandardCharsets.UTF_8));
            stream.flush();
        }
    }

    private String toString(HttpExchange he) {
        StringBuilder sb = new StringBuilder();
        sb.append("Local Address: ").append(he.getLocalAddress()).append("\n");
        sb.append("Remote Address: ").append(he.getRemoteAddress()).append("\n");
        sb.append("Principal: ").append(he.getPrincipal()).append("\n");
        sb.append("Protocol: ").append(he.getProtocol()).append("\n");
        sb.append("Request Method: ").append(he.getRequestMethod()).append("\n");
        sb.append("Request URI: ").append(he.getRequestURI()).append("\n");
        sb.append("Request Headers:\n");
        he.getRequestHeaders().forEach((key, value) -> sb.append("   ").append((String)key).append(":").append(value).append("\n"));
        return sb.toString();
    }

    private class SuccessImgServlet
    implements HttpHandler {
        private SuccessImgServlet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange he) throws IOException {
            he.getResponseHeaders().add("Content-Type", "image/png");
            Image img = ImageUtilities.loadImage((String)"com/paterva/maltego/pws/resources/Success.png", (boolean)true);
            BufferedImage buffImg = ImageUtils.createBufferedImage((Image)img);
            he.sendResponseHeaders(200, 0L);
            try (OutputStream stream = he.getResponseBody();){
                ImageIO.write((RenderedImage)buffImg, "png", stream);
                stream.flush();
            }
            finally {
                he.close();
            }
        }
    }

    private class SuccessServlet
    implements HttpHandler {
        private SuccessServlet() {
        }

        @Override
        public void handle(HttpExchange he) throws IOException {
            String response = String.format("<html><body><img style=\"display: table;margin: 0 auto;padding-top: 50px\" src=\"%s\"/></body></html>", OAuthAuthenticatorService.SUCCESS_IMG);
            OAuthAuthenticatorService.this.sendOkResponse(he, response);
            he.close();
            Timer timer = new Timer(1000, ignored -> {
                try {
                    OAuthAuthenticatorService.this.stop();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    private class CallbackServlet
    implements HttpHandler {
        private CallbackServlet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange he) throws IOException {
            LOG.fine(() -> "Callback request:\n" + OAuthAuthenticatorService.this.toString(he));
            try {
                OAuth10aService authService;
                OAuthService service;
                OAuth1AccessToken at = null;
                String query = he.getRequestURI().getQuery();
                Map<String, String> params = OAuthHttpUtils.getParameters(query);
                String primaryKey = OAuthAuthenticatorService.this._model.isOAuthV2() ? "code" : "oauth_verifier";
                String verifierStr = params.get(primaryKey);
                if (verifierStr == null) {
                    verifierStr = "";
                }
                if ((service = OAuthAuthenticatorService.this._model.getService()) instanceof OAuth10aService) {
                    authService = (OAuth10aService)service;
                    at = authService.getAccessToken(OAuthAuthenticatorService.this._requestToken, verifierStr);
                } else if (service instanceof OAuth20Service) {
                    authService = (OAuth20Service)service;
                    OAuth2AccessToken accessToken = authService.getAccessToken(verifierStr);
                    if (OAuthAuthenticatorService.this._model.usesRefreshTokens()) {
                        OAuthAuthenticatorService.this.adjustExpiryTime(accessToken.getExpiresIn());
                    }
                    at = accessToken;
                }
                OAuth1AccessToken accessToken = at;
                if (OAuthAuthenticatorService.this._cb != null) {
                    SwingUtilities.invokeLater(() -> this.lambda$handle$1((Token)accessToken));
                }
                String response = String.format("<html>\n<head>\n    <title>Redirecting...</title>\n    <script>\n    function redirLoad(){\n        document.getElementById(\"redirForm\").submit();\n    }\n    </script>\n</head>\n<body onload=\"redirLoad()\">\n    <form id=\"redirForm\" action=\"%s\"/>\n</body>\n</html>", OAuthAuthenticatorService.this._model.getServletUrl(OAuthAuthenticatorService.this._model.getSuccessContextName()));
                OAuthAuthenticatorService.this.sendOkResponse(he, response);
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
                OAuthAuthenticatorService.this.sendOkResponse(he, ex.toString());
            }
            finally {
                he.close();
            }
        }

        private /* synthetic */ void lambda$handle$1(Token accessToken) {
            OAuthAuthenticatorService.this._cb.success(accessToken);
        }
    }

    private class SigninServlet
    implements HttpHandler {
        private SigninServlet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange he) throws IOException {
            try {
                OAuth10aService authService;
                LOG.fine(() -> "Sign in request:\n" + OAuthAuthenticatorService.this.toString(he));
                String authorizationUrl = null;
                OAuthService service = OAuthAuthenticatorService.this._model.getService();
                if (service instanceof OAuth10aService) {
                    authService = (OAuth10aService)service;
                    OAuthAuthenticatorService.this._requestToken = authService.getRequestToken();
                    authorizationUrl = authService.getAuthorizationUrl(OAuthAuthenticatorService.this._requestToken);
                } else if (service instanceof OAuth20Service) {
                    authService = (OAuth20Service)service;
                    authorizationUrl = authService.getAuthorizationUrl();
                    if (OAuthAuthenticatorService.this._model.usesRefreshTokens()) {
                        OAuthAuthenticatorService.this.setRequestTime();
                    }
                }
                if (authorizationUrl != null) {
                    String requestType = OAuthAuthenticatorService.this._model.getRequestTypeForAuthorizationUrl().name();
                    boolean get = "GET".equals(requestType);
                    LOG.log(Level.FINE, "Redirect to: {0} ({1})", new String[]{authorizationUrl, get ? "GET" : "POST"});
                    if (get) {
                        he.getResponseHeaders().add("Location", authorizationUrl);
                        he.sendResponseHeaders(302, 0L);
                    } else {
                        String response = OAuthHttpUtils.buildHtmlRedirect(authorizationUrl, requestType);
                        OAuthAuthenticatorService.this.sendOkResponse(he, response);
                    }
                }
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
                OAuthAuthenticatorService.this.sendOkResponse(he, ex.toString());
            }
            finally {
                he.close();
            }
        }
    }
}

