/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts.link;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.EntityDataQuery;
import com.paterva.maltego.graph.store.query.part.EntitySectionsQuery;
import com.paterva.maltego.graph.store.query.part.PartSectionsQuery;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.treelist.parts.PartNode;
import com.paterva.maltego.treelist.parts.PartsRowModel;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class LinkRowModel
extends PartsRowModel<LinkID, MaltegoLink> {
    private static final Logger LOG = Logger.getLogger(LinkRowModel.class.getName());
    public static final int COLUMN_INSPECT = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_TARGET = 2;
    public static final int COLUMN_COUNT = 3;

    public LinkRowModel(PartsTreelistModel<LinkID, MaltegoLink> partProvider) {
        super(partProvider);
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueFor(Object node, int column) {
        PartNode partNode = (PartNode)node;
        switch (column) {
            case 0: {
                return partNode;
            }
            case 1: {
                return this.getSource(partNode);
            }
            case 2: {
                return this.getTarget(partNode);
            }
        }
        LOG.log(Level.SEVERE, "Unknown column: {0}", column);
        return null;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return PartNode.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
        }
        LOG.log(Level.SEVERE, "Unknown column: {0}", column);
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Inspect";
            }
            case 1: {
                return "Source";
            }
            case 2: {
                return "Target";
            }
        }
        LOG.log(Level.SEVERE, "Unknown column: {0}", column);
        return null;
    }

    private String getSource(PartNode<LinkID, MaltegoLink> partNode) {
        String entityName = null;
        LinkID linkID = partNode.getPartID();
        if (linkID != null) {
            try {
                GraphID graphID = this.getModel().getGraphID();
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                EntityID sourceID = structureReader.getSource(linkID);
                entityName = this.getDisplayName(graphStore, sourceID);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return entityName;
    }

    private String getTarget(PartNode<LinkID, MaltegoLink> partNode) {
        String entityName = null;
        LinkID linkID = partNode.getPartID();
        if (linkID != null) {
            try {
                GraphID graphID = this.getModel().getGraphID();
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                EntityID targetID = structureReader.getTarget(linkID);
                entityName = this.getDisplayName(graphStore, targetID);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return entityName;
    }

    private String getDisplayName(GraphStore graphStore, EntityID entityID) throws GraphStoreException {
        GraphDataStoreReader dataStoreReader = graphStore.getGraphDataStore().getDataStoreReader();
        EntityDataQuery entityDataQuery = new EntityDataQuery();
        entityDataQuery.setAllSections(false);
        EntitySectionsQuery entitySectionsQuery = new EntitySectionsQuery();
        entitySectionsQuery.setQueryCachedDisplayStr(true);
        entityDataQuery.setSections((PartSectionsQuery)entitySectionsQuery);
        entityDataQuery.setAllProperties(false);
        entityDataQuery.setPropertyNames(Collections.EMPTY_SET);
        MaltegoEntity entity = dataStoreReader.getEntity(entityID, entityDataQuery);
        return entity.getDisplayString();
    }
}

