package cli

/*
	Sliver Implant Framework
	Copyright (C) 2019  Bishop Fox

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

import (
	"fmt"
	"sort"

	"github.com/bishopfox/sliver/client/assets"
	"github.com/bishopfox/sliver/client/forms"
)

func selectConfig() (string, *assets.ClientConfig) {
	configs := assets.GetConfigs()

	if len(configs) == 0 {
		return "", nil
	}

	if len(configs) == 1 {
		for key, config := range configs {
			return key, config
		}
	}

	keys := make([]string, 0, len(configs))
	for key := range configs {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	selection := keys[0]
	err := forms.Select("Select a server:", keys, &selection)
	if err != nil {
		fmt.Println(err.Error())
		return "", nil
	}

	return selection, configs[selection]
}
