% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep_len_linter.R
\name{rep_len_linter}
\alias{rep_len_linter}
\title{Require usage of rep_len(x, n) over rep(x, length.out = n)}
\usage{
rep_len_linter()
}
\description{
\code{rep(x, length.out = n)} calls \code{rep_len(x, n)} "under the hood". The latter
is thus more direct and equally readable.
}
\examples{
# will produce lints
lint(
  text = "rep(1:3, length.out = 10)",
  linters = rep_len_linter()
)

# okay
lint(
  text = "rep_len(1:3, 10)",
  linters = rep_len_linter()
)

lint(
  text = "rep(1:3, each = 2L, length.out = 10L)",
  linters = rep_len_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}
}
