% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winfunc.R
\name{window functions}
\alias{window functions}
\alias{hanning}
\alias{hamming}
\alias{blackman}
\alias{bartlett}
\alias{welch}
\alias{flattop}
\alias{bharris}
\alias{bnuttall}
\alias{sine}
\alias{nuttall}
\alias{bhann}
\alias{lanczos}
\alias{gauss}
\alias{tukey}
\alias{dolph}
\alias{cauchy}
\alias{parzen}
\alias{bohman}
\title{Window functions}
\usage{
hanning(n)

hamming(n)

blackman(n)

bartlett(n)

welch(n)

flattop(n)

bharris(n)

bnuttall(n)

sine(n)

nuttall(n)

bhann(n)

lanczos(n)

gauss(n)

tukey(n)

dolph(n)

cauchy(n)

parzen(n)

bohman(n)
}
\arguments{
\item{n}{size of the window (number of weights to generate)}
}
\description{
Several common \href{https://en.wikipedia.org/wiki/Window_function}{windows function}
generators. The functions return a vector of weights to use in \link{read_audio_fft}.
}
\examples{
# Window functions
plot(hanning(1024), type = 'l', xlab = 'window', ylab = 'weight')
lines(hamming(1024), type = 'l', col = 'red')
lines(bartlett(1024), type = 'l', col = 'blue')
lines(welch(1024), type = 'l', col = 'purple')
lines(flattop(1024), type = 'l', col = 'darkgreen')
}
