% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/set_methods.R
\name{views_names}
\alias{views_names}
\alias{views_names<-}
\alias{views_names,MOFA-method}
\alias{views_names<-,MOFA,character-method}
\title{views_names: set and retrieve view names}
\usage{
views_names(object)

views_names(object) <- value

\S4method{views_names}{MOFA}(object)

\S4method{views_names}{MOFA,character}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{value}{character vector with the names for each view}
}
\value{
character vector with the names for each view
}
\description{
views_names: set and retrieve view names
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
views_names(model)
views_names(model) <- c("viewA", "viewB")
}
