/*****************************************************************************
 * Test cases for libxlsxwriter.
 *
 * Test to compare output against Excel files.
 *
 * SPDX-License-Identifier: BSD-2-Clause
 * Copyright 2014-2026, John McNamara, jmcnamara@cpan.org.
 *
 */

#include "xlsxwriter.h"


unsigned char image_buffer[] = {
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x48,
    0x08, 0x02, 0x00, 0x00, 0x00, 0xda, 0x8f, 0x24, 0x10, 0x00, 0x00, 0x00,
    0x01, 0x73, 0x52, 0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00,
    0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1, 0x8f, 0x0b, 0xfc,
    0x61, 0x05, 0x00, 0x00, 0x00, 0x20, 0x63, 0x48, 0x52, 0x4d, 0x00, 0x00,
    0x7a, 0x26, 0x00, 0x00, 0x80, 0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00,
    0x80, 0xe8, 0x00, 0x00, 0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00,
    0x3a, 0x98, 0x00, 0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00,
    0x00, 0xba, 0x49, 0x44, 0x41, 0x54, 0x68, 0x43, 0xed, 0xd8, 0x39, 0x0e,
    0x80, 0x30, 0x10, 0x04, 0x41, 0xf8, 0xff, 0xa3, 0x39, 0x32, 0x12, 0xc2,
    0x3d, 0x55, 0x88, 0xd8, 0xd6, 0xa8, 0x7b, 0xc7, 0x86, 0xf3, 0xba, 0x8e,
    0x9d, 0xcf, 0x13, 0x6c, 0xe5, 0xbb, 0x33, 0xd5, 0xab, 0xe1, 0x4a, 0x5c,
    0x82, 0x0d, 0x9c, 0x43, 0x2a, 0x4e, 0x83, 0x86, 0x18, 0x62, 0x4d, 0xce,
    0x0f, 0x2a, 0x52, 0x91, 0x8a, 0xb1, 0x53, 0x10, 0xbb, 0x7a, 0x21, 0x3d,
    0xc1, 0x94, 0x47, 0xa1, 0x7e, 0xdf, 0xad, 0xa9, 0x48, 0x45, 0x2a, 0xc6,
    0x4e, 0x41, 0xec, 0xea, 0x85, 0xf4, 0x04, 0x53, 0x1e, 0x85, 0xfa, 0x39,
    0xc7, 0xa6, 0xe9, 0x87, 0x18, 0x62, 0x4d, 0x0a, 0x83, 0x8a, 0x54, 0xa4,
    0x62, 0xde, 0x0d, 0x2e, 0x6f, 0xa7, 0x64, 0xaa, 0x82, 0x4d, 0x2b, 0x12,
    0xc4, 0x10, 0x4b, 0x2e, 0x89, 0xbf, 0xed, 0xa8, 0x48, 0x45, 0x2a, 0xc6,
    0x4e, 0x41, 0xec, 0xea, 0x85, 0xf4, 0x04, 0x53, 0x1e, 0x85, 0xfa, 0xf9,
    0x82, 0x9e, 0xa6, 0x1f, 0x62, 0x88, 0x35, 0x29, 0x0c, 0x2a, 0x52, 0x91,
    0x8a, 0x79, 0x37, 0xb8, 0xbc, 0x9d, 0x92, 0xa9, 0x0a, 0x36, 0xad, 0x48,
    0x10, 0x43, 0x2c, 0xb9, 0x24, 0xfc, 0x7e, 0x9b, 0xa6, 0x1c, 0x62, 0x88,
    0x35, 0x29, 0x09, 0x2a, 0x6e, 0x51, 0xf1, 0x06, 0xdf, 0x57, 0xcc, 0x59,
    0x4b, 0x53, 0xe3, 0x49, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
    0xae, 0x42, 0x60, 0x82
};

unsigned int image_size = 316;

int main() {

    lxw_workbook  *workbook  = workbook_new("test_image83.xlsx");
    lxw_worksheet *worksheet = workbook_add_worksheet(workbook, NULL);

    lxw_image_options options = {.x_offset = 1, .y_offset = 2,
                                 .description = "yellow.png"};

    worksheet_insert_image_buffer_opt(worksheet, CELL("D7"), image_buffer, image_size, &options);

    return workbook_close(workbook);
}
