/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.callable.AbstractCallableBit;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractInjectionBit<T extends AbstractCallableBit<T>> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected final InjectionModel injectionModel;
    protected final BlindOperator blindOperator;

    protected AbstractInjectionBit(InjectionModel injectionModel, BlindOperator blindOperator) {
        this.injectionModel = injectionModel;
        this.blindOperator = blindOperator;
    }

    public abstract boolean isInjectable() throws StoppedByUserSlidingException;

    public abstract void initNextChar(String var1, List<char[]> var2, AtomicInteger var3, CompletionService<T> var4, AtomicInteger var5, AtomicInteger var6, T var7);

    public abstract char[] initMaskAsciiChar(List<char[]> var1, T var2);

    public abstract String getInfoMessage();

    public String inject(String sqlQuery, AbstractSuspendable suspendable) throws StoppedByUserSlidingException {
        ArrayList<char[]> bytes = new ArrayList<char[]>();
        AtomicInteger indexChar = new AtomicInteger(0);
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableAbstractBoolean");
        ExecutorCompletionService taskCompletionService = new ExecutorCompletionService(taskExecutor);
        AtomicInteger countTasksSubmitted = new AtomicInteger(0);
        AtomicInteger countBadAsciiCode = new AtomicInteger(0);
        this.initNextChar(sqlQuery, bytes, indexChar, taskCompletionService, countTasksSubmitted, countBadAsciiCode, null);
        while (countTasksSubmitted.get() > 0) {
            if (suspendable.isSuspended()) {
                String result = this.stop(bytes, taskExecutor);
                throw new StoppedByUserSlidingException(result);
            }
            try {
                String result;
                AbstractCallableBit currentCallable = (AbstractCallableBit)taskCompletionService.take().get();
                countTasksSubmitted.decrementAndGet();
                boolean isComplete = this.isCharCompleteWithCorruptCheck(bytes, countBadAsciiCode, currentCallable);
                if (isComplete || currentCallable.isBinary()) {
                    this.initNextChar(sqlQuery, bytes, indexChar, taskCompletionService, countTasksSubmitted, countBadAsciiCode, currentCallable);
                }
                if (!(result = AbstractInjectionBit.convert(bytes)).matches("(?s).*\\x01\\x03\\x03\\x07.*")) continue;
                countTasksSubmitted.set(0);
                break;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
            catch (InjectionFailureException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, e.getMessage());
                break;
            }
        }
        return this.stop(bytes, taskExecutor);
    }

    private static String convert(List<char[]> bytes) {
        StringBuilder result = new StringBuilder();
        for (char[] c : bytes) {
            try {
                int charCode = Integer.parseInt(new String(c), 2);
                String str = Character.toString((char)charCode);
                result.append(str);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result.toString();
    }

    protected boolean isCharCompleteWithCorruptCheck(List<char[]> bytes, AtomicInteger countBadAsciiCode, T currentCallable) throws InjectionFailureException {
        char[] maskAsciiChar = this.initMaskAsciiChar(bytes, currentCallable);
        String asciiCodeBit = new String(maskAsciiChar);
        boolean isComplete = false;
        if (asciiCodeBit.matches("^[01]{8}$")) {
            int asciiCode = Integer.parseInt(asciiCodeBit, 2);
            if (asciiCode == 127 || asciiCode == 0) {
                if (countBadAsciiCode.get() > 15) {
                    throw new InjectionFailureException("Boolean false positive, stopping...");
                }
                countBadAsciiCode.incrementAndGet();
            }
            ((AbstractCallableBit)currentCallable).setCharText(Character.toString((char)asciiCode));
            Request interaction = new Request();
            interaction.setMessage(Interaction.MESSAGE_BINARY);
            interaction.setParameters(asciiCodeBit + "=" + ((AbstractCallableBit)currentCallable).getCharText().replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t"));
            this.injectionModel.sendToViews(interaction);
            isComplete = true;
        }
        return isComplete;
    }

    private String stop(List<char[]> bytes, ExecutorService taskExecutor) {
        this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
        StringBuilder result = new StringBuilder();
        for (char[] c : bytes) {
            try {
                int charCode = Integer.parseInt(new String(c), 2);
                String str = Character.toString((char)charCode);
                result.append(str);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result.toString();
    }

    public String callUrl(String urlString, String metadataInjectionProcess) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess);
    }

    public String callUrl(String urlString, String metadataInjectionProcess, AbstractCallableBit<?> callableBoolean) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess, callableBoolean);
    }

    public BlindOperator getBlindOperator() {
        return this.blindOperator;
    }

    protected static char[] getBitsUnset() {
        return new char[]{'0', 'x', 'x', 'x', 'x', 'x', 'x', 'x'};
    }

    public static enum BlindOperator {
        AND,
        OR,
        STACK,
        NO_MODE;

    }
}

