ITK 5.3 Release Candidate 2 Release Notes: Grow Cuts
=====================================================

We are happy to announce the [Insight Toolkit (ITK)](https://itk.org) 5.3 Release Candidate 2 is available for testing! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

ITK 5.3 is a feature release that accelerates performance, provides new segmentation and shape analysis algorithms, and makes over 200 more improvements. For more information about performance improvements, see [the 5.3 RC 1 Release Notes](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.3rc01).

ITK 5.3 RC 2 highlights a new remote module, [ITKGrowCut](https://github.com/InsightSoftwareConsortium/ITKGrowCut), which segments a 3D image from user-provided seeds. This method was popularized by [3D Slicer](https://slicer.org) and was improved for inclusion in [Seg3D](http://www.seg3d.org/) with support from the National Institute of General Medical Sciences (NIGMS) of the National Institutes of Health (NIH) under grant numbers P41 GM103545 and R24 GM136986. This module can also be scripted in Python through a package installed with:

```
pip install itk-growcut
```


![](https://i.imgur.com/nHVCS8Y.png)
Seeds for ITKGrowCut module.

![](https://i.imgur.com/r3dG6mp.png)
Results produced by ITKGrowCut module.


Download
--------

**Python Packages**

Install [ITK Python packages](https://itkpythonpackage.readthedocs.io/en/latest/Quick_start_guide.html) with:

```
pip install --upgrade --pre itk
```

**Library Sources**

- [InsightToolkit-5.3rc02.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc02/InsightToolkit-5.3rc02.tar.gz)
- [InsightToolkit-5.3rc02.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc02/InsightToolkit-5.3rc02.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.3rc02.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc02/InsightData-5.3rc02.tar.gz)
- [InsightData-5.3rc02.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc02/InsightData-5.3rc02.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc02/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc02/SHA512SUMS)


Features
--------

### Python

- Python packages now include oneTBB support for improved performance.
- Following CPython's deprecation schedule Python 3.6 is no longer supported.
- Python packages added for Python 3.10
- Initial Python wrapping is available for the Video modules.
- `TransformToDisplacementField` is now available in Python.
- Pythonic IO functions `itk.imread` understands `pathlib.Path`'s
- New `repr` for `itk.Matrix`
- `np.asarray` works on `itk.Matrix`
- `DCMTKImageIO` wrapping addressed


### C++

- C++14 is now required.
- The minimum CMake version required is now 3.16.3.
- New functions: `MakePoint`, `MakeVector`, `MakeIndex`, `MakeSize`.
- Targets in Visual Studio and other IDE's are now organize hierachically by ITK Group and Module
- Most of `itk::mpl` meta-programming functions replaced by C++14 equivalents
- Performance accelerations for b-spline interpolation, Mattes mutual information metric computation
- Improved modern C++ adoption, e.g. additional adoption of `constexpr`, `auto`

### New filters

- `itk::TransformGeometryImageFilter`: applies a rigid transform to an `Image`'s metadata.
- 1D FFT classes
    - Interface classes for forward, inverse transformations, half-hermetian transformations
    - Vnl implementations
    - FFTW implementations

### Remote module updates

New remote modules:

- [HASI](https://github.com/KitwareMedical/HASI): High-Throughput Applications for Skeletal Imaging
- [ITKGrowCut](https://github.com/InsightSoftwareConsortium/ITKGrowCut): segments a 3D image from user-provided foreground and background seeds

Updated modules: *AdaptiveDenoising*, *AnisotropicDiffusionLBR*, *BSplineGradient*, *BoneEnhancement*, *BoneMorphometry*, *Cuberille*, *GrowCut*, *HASI*, *HigherOrderAccurateGradient*, *IOFDF*, *IOScanco*, *IsotropicWavelets*, *MinimalPathExtraction*, *Montage*, *MorphologicalContourInterpolation*, *RTK*, *SimpleITKFilters*, *SkullStrip*, *SplitComponents*, *Strain*, *TextureFeatures*, *Thickness3D*, *TotalVariation*, *TubeTK*, and *Ultrasound*.


### Third party library updates

- expat
- fftw
- gdcm
- googletest
- hdf5
- kwsys
- metaio
- niftilib
- vxl
- zlib migrated to zlib-ng

### Congratulations

Congratulations and **thank you** to everyone who contributed to this release.

Of the *41 authors* who contributed since v5.2.0, we would like to specially recognize the new contributors:

*Pranjal Sahu, Darren Thompson, Tomoyuki SADAKANE, Oleksandr Zavalistyi, Jose Tascon, Kian Weimer, Michael Kuczynski, Ebrahim Ebrahim, Philip Cook, ambrozicc1, Jason Rudy, josempozo, Andreas Gravgaard Andersen, and Hastings Greer.*


What's Next
-----------


We anticipate an additional release candidate following community testing before the 5.3.0 release. The following release candidate(s) will improve related documentation and make further improvements. Please try out the current release candidate, and discuss your experiences at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

**Enjoy ITK!**

ITK Changes Since v5.3rc01
---------------------------------------------

### Aaron Bray (1):

#### Enhancements

- Create an IDE folder structure (#2791) ([569f96529e](https://github.com/InsightSoftwareConsortium/ITK/commit/569f96529e))


### Andreas Gravgaard Andersen (4):

#### Enhancements

- Update expat files ([9e337d3a23](https://github.com/InsightSoftwareConsortium/ITK/commit/9e337d3a23))
- Update expat CMake config ([95ab3c2a3d](https://github.com/InsightSoftwareConsortium/ITK/commit/95ab3c2a3d))
- Update exported symbols for expat ([ea54bc77d7](https://github.com/InsightSoftwareConsortium/ITK/commit/ea54bc77d7))
- re-apply ITK symbol export definitions ([0e9afe968a](https://github.com/InsightSoftwareConsortium/ITK/commit/0e9afe968a))


### Brad King (3):

#### Enhancements

- Update to newer third-party update script ([28bf772844](https://github.com/InsightSoftwareConsortium/ITK/commit/28bf772844))
- Convert MetaIO import script to use update-third-party.bash ([b59cfe70d3](https://github.com/InsightSoftwareConsortium/ITK/commit/b59cfe70d3))
- Update to newer third-party update script ([19155f3996](https://github.com/InsightSoftwareConsortium/ITK/commit/19155f3996))


### Bradley Lowekamp (6):

#### Enhancements

- Refactor TransformGeometryImageFilter pipeline i/o ([2de73abe37](https://github.com/InsightSoftwareConsortium/ITK/commit/2de73abe37))
- Use InPlaceImageFilter for base class, run in-place by default ([4379b75c2a](https://github.com/InsightSoftwareConsortium/ITK/commit/4379b75c2a))
- Support generic linear Transform ([978bc5b9f5](https://github.com/InsightSoftwareConsortium/ITK/commit/978bc5b9f5))

#### Bug Fixes

- Use GenerateOutputInformation and pipeline isolation ([374940a1c6](https://github.com/InsightSoftwareConsortium/ITK/commit/374940a1c6))
- Fix ImageRegionSplitters with zero sized image ([63f4ab7dd8](https://github.com/InsightSoftwareConsortium/ITK/commit/63f4ab7dd8))
- Install ITKInitializeCXXStandard.cmake ([98f0f5c5ed](https://github.com/InsightSoftwareConsortium/ITK/commit/98f0f5c5ed))


### Bryn Lloyd (2):

#### Bug Fixes

- pythonic itk should understand pathlib.Path ([051ad61e26](https://github.com/InsightSoftwareConsortium/ITK/commit/051ad61e26))
- failing test - only pythonic api knows PathLike paths ([0178cf01af](https://github.com/InsightSoftwareConsortium/ITK/commit/0178cf01af))


### Dženan Zukić (14):

#### Enhancements

- use std::enable_if instead of itk::mpl::EnableIf ([6b58ee8fce](https://github.com/InsightSoftwareConsortium/ITK/commit/6b58ee8fce))
- deprecate itk::EnableIf and the header which implements it ([9f3a6243bf](https://github.com/InsightSoftwareConsortium/ITK/commit/9f3a6243bf))
- replace instances of mpl::IsSame by std::is_same ([c28930c90f](https://github.com/InsightSoftwareConsortium/ITK/commit/c28930c90f))
- deprecate itk::IsSame and the header which implements it ([342845e644](https://github.com/InsightSoftwareConsortium/ITK/commit/342845e644))
- replace itkStaticAssert by STL's static_assert ([cd43985eba](https://github.com/InsightSoftwareConsortium/ITK/commit/cd43985eba))
- fully cover the logical test cases in MetaProgrammingLibraryTest ([dcd7dfd469](https://github.com/InsightSoftwareConsortium/ITK/commit/dcd7dfd469))
- replace usage of IsBaseOf by std::is_base_of ([e90519eeed](https://github.com/InsightSoftwareConsortium/ITK/commit/e90519eeed))
- deprecate mpl::IsBaseOf and the header which implements it ([d458298bdd](https://github.com/InsightSoftwareConsortium/ITK/commit/d458298bdd))
- Deprecated mpl::IsConvertible and the header which implements it ([2f29c8d2d0](https://github.com/InsightSoftwareConsortium/ITK/commit/2f29c8d2d0))
- switch to zlib-ng official repository ([dcaecbe147](https://github.com/InsightSoftwareConsortium/ITK/commit/dcaecbe147))

#### Platform Fixes

- remove a workaround for a bug in Visual Studio 2015 ([2f732c0f05](https://github.com/InsightSoftwareConsortium/ITK/commit/2f732c0f05))
- fix VS2017 compile error in itkFEMElementStd.h ([182d302823](https://github.com/InsightSoftwareConsortium/ITK/commit/182d302823))

#### Style Changes

- nifti_installed_targets message is gray instead of default red ([83a51e21c6](https://github.com/InsightSoftwareConsortium/ITK/commit/83a51e21c6))
- remove unnecessary parentheses around logical conditions ([e092a3df47](https://github.com/InsightSoftwareConsortium/ITK/commit/e092a3df47))


### Hans Johnson (3):

#### Enhancements

- Update FFTW to 3.3.10 ([03338d41c9](https://github.com/InsightSoftwareConsortium/ITK/commit/03338d41c9))

#### Bug Fixes

- Wrong superclass identified for child class. ([e64795cee5](https://github.com/InsightSoftwareConsortium/ITK/commit/e64795cee5))

#### Style Changes

- Avoid repeating parent aliases ([4f309803b9](https://github.com/InsightSoftwareConsortium/ITK/commit/4f309803b9))


### Hastings Greer (1):

#### Enhancements

- Make representation match repr(itkVector) ([5210cc23ab](https://github.com/InsightSoftwareConsortium/ITK/commit/5210cc23ab))


### HastingsGreer (1):

#### Enhancements

- Add a useful __repr__ for itkMatrix ([152ed0028f](https://github.com/InsightSoftwareConsortium/ITK/commit/152ed0028f))


### Jason Rudy (1):

#### Platform Fixes

- Fix Python wrapping of DCMTKImageIO. Closes #2762. ([40235a57b4](https://github.com/InsightSoftwareConsortium/ITK/commit/40235a57b4))


### Jon Haitz Legarreta Gorroño (25):

#### Enhancements

- Add further regexes for the issue/PR labeler ([bffcf331db](https://github.com/InsightSoftwareConsortium/ITK/commit/bffcf331db))
- Improve KLCompareHistogramImageToImageMetric coverage ([77fc43ba1b](https://github.com/InsightSoftwareConsortium/ITK/commit/77fc43ba1b))
- Improve KLCompareHistogramImageToImageMetric coverage ([eec8c4dd2a](https://github.com/InsightSoftwareConsortium/ITK/commit/eec8c4dd2a))
- Increase forward/inverse 1D FFT filters' coverage ([89837f6b80](https://github.com/InsightSoftwareConsortium/ITK/commit/89837f6b80))
- Increase code coverage ([c4a359cc98](https://github.com/InsightSoftwareConsortium/ITK/commit/c4a359cc98))

#### Platform Fixes

- Fix missing initialization braces warning ([c7641fc000](https://github.com/InsightSoftwareConsortium/ITK/commit/c7641fc000))
- Fix missing initialization braces warning ([33d1d0d3cc](https://github.com/InsightSoftwareConsortium/ITK/commit/33d1d0d3cc))
- Fix missing initialization braces warning ([c19cdcdf4e](https://github.com/InsightSoftwareConsortium/ITK/commit/c19cdcdf4e))
- Fix undeclared identifier error ([94dfea440b](https://github.com/InsightSoftwareConsortium/ITK/commit/94dfea440b))
- Mark class destructors with `override` ([1daf2182f8](https://github.com/InsightSoftwareConsortium/ITK/commit/1daf2182f8))
- Mark class destructors with `override` ([7ef2496a26](https://github.com/InsightSoftwareConsortium/ITK/commit/7ef2496a26))

#### Bug Fixes

- Provide missing template parameter to superclass ([280c43e6a2](https://github.com/InsightSoftwareConsortium/ITK/commit/280c43e6a2))

#### Style Changes

- Avoid repeating parent aliases in operator classes ([babece933d](https://github.com/InsightSoftwareConsortium/ITK/commit/babece933d))
- Improve `itk::SimilarityIndexImageFilter` class test file style ([ada00b5a00](https://github.com/InsightSoftwareConsortium/ITK/commit/ada00b5a00))
- Sort the infrastructure regexes in labeler dictionary ([8225a45cad](https://github.com/InsightSoftwareConsortium/ITK/commit/8225a45cad))
- Remove unnecessary implementation file manual instantiation guard ([36bb69db44](https://github.com/InsightSoftwareConsortium/ITK/commit/36bb69db44))
- Improve the ivar printing in `PrintSelf` methods ([286fca2694](https://github.com/InsightSoftwareConsortium/ITK/commit/286fca2694))
- Make `itkLabelImageToLabelMapFilterTest` style consistent ([014c08fc68](https://github.com/InsightSoftwareConsortium/ITK/commit/014c08fc68))
- Improve the ivar printing in `PrintSelf` methods ([ef5a73456a](https://github.com/InsightSoftwareConsortium/ITK/commit/ef5a73456a))
- Make `IODCMTK` module test style consistent ([9cf28765c8](https://github.com/InsightSoftwareConsortium/ITK/commit/9cf28765c8))
- Make `FFT` module test style consistent ([59f16e7094](https://github.com/InsightSoftwareConsortium/ITK/commit/59f16e7094))
- Make style consistent in miscellaneous tests ([5ce113f95b](https://github.com/InsightSoftwareConsortium/ITK/commit/5ce113f95b))
- Prefer = default to explicitly trivial implementations ([85e80f1fb0](https://github.com/InsightSoftwareConsortium/ITK/commit/85e80f1fb0))
- Prefer = default to explicitly trivial implementations ([9b7464014d](https://github.com/InsightSoftwareConsortium/ITK/commit/9b7464014d))
- Make CMake flag help text third-party toolkit names consistent ([867bf80e16](https://github.com/InsightSoftwareConsortium/ITK/commit/867bf80e16))


### KWSys Upstream (1):

#### Miscellaneous Changes

- KWSys 2021-10-08 (b8c734ba) ([bdbe89864e](https://github.com/InsightSoftwareConsortium/ITK/commit/bdbe89864e))


### Lee Newberg (1):

#### Bug Fixes

- Correct extra reference count from ObjectFactory<Self>::Create() ([d8742f00b8](https://github.com/InsightSoftwareConsortium/ITK/commit/d8742f00b8))


### Matt McCormick (11):

#### Enhancements

- Support np.asarray on itk.Matrix ([76fa38c13f](https://github.com/InsightSoftwareConsortium/ITK/commit/76fa38c13f))
- Add MD5 content links for ITK 5.3RC2 ([b218281460](https://github.com/InsightSoftwareConsortium/ITK/commit/b218281460))

#### Documentation Updates

- Recommend GitHub CLI ([5e0a11483f](https://github.com/InsightSoftwareConsortium/ITK/commit/5e0a11483f))
- Document Linux ARM Python package builds ([509a66e176](https://github.com/InsightSoftwareConsortium/ITK/commit/509a66e176))
- Software Guide link to GeodesicActiveContourShapePriorLevelSetImageFilter ([911430821c](https://github.com/InsightSoftwareConsortium/ITK/commit/911430821c))

#### Platform Fixes

- Avoid Superclass type alias GCC compile errors ([230be6be26](https://github.com/InsightSoftwareConsortium/ITK/commit/230be6be26))
- Update CircleCI image to cimg/python:3.9 ([b9e51f1c0d](https://github.com/InsightSoftwareConsortium/ITK/commit/b9e51f1c0d))
- Initialize CXX standard in ITK_USE_FILE ([9233ef9a7d](https://github.com/InsightSoftwareConsortium/ITK/commit/9233ef9a7d))
- Update KWStyle for macOS unknown -Wdeprecated-copy ([0cc6867f37](https://github.com/InsightSoftwareConsortium/ITK/commit/0cc6867f37))

#### Bug Fixes

- Improve dimension-dependent BSplineInterpolationWeightFunction wrapping ([61f98c7fff](https://github.com/InsightSoftwareConsortium/ITK/commit/61f98c7fff))
- Remove unused FFT1D testing data content links ([ae983e8170](https://github.com/InsightSoftwareConsortium/ITK/commit/ae983e8170))


### MetaIO Maintainers (2):

#### Miscellaneous Changes

- MetaIO 2021-06-24 (3f37ad78) ([f3adb4ec2e](https://github.com/InsightSoftwareConsortium/ITK/commit/f3adb4ec2e))
- MetaIO 2021-09-28 (5e87f062) ([9b85a2fe1a](https://github.com/InsightSoftwareConsortium/ITK/commit/9b85a2fe1a))


### Niels Dekker (24):

#### Enhancements

- Add static `FastEvaluate(u)` to `BSplineDerivativeKernelFunction` ([760ae1246c](https://github.com/InsightSoftwareConsortium/ITK/commit/760ae1246c))
- Add `RegisterInternalFactoryOnce<TFactory>()` to ObjectFactoryBase ([9f29a52d6c](https://github.com/InsightSoftwareConsortium/ITK/commit/9f29a52d6c))
- Improve thread-safety of registration of internal IO factories ([fb47ffaf62](https://github.com/InsightSoftwareConsortium/ITK/commit/fb47ffaf62))

#### Performance Improvements

- Use FixedArray for table within BSplineInterpolationWeightFunction ([974540982b](https://github.com/InsightSoftwareConsortium/ITK/commit/974540982b))
- Use FastEvaluate in MattesMutualInformationImageToImageMetric + v4 ([9961ccd672](https://github.com/InsightSoftwareConsortium/ITK/commit/9961ccd672))
- Remove unnecessary `IdentityTransform::m_ZeroJacobian` ([eec9fe6705](https://github.com/InsightSoftwareConsortium/ITK/commit/eec9fe6705))
- Remove protected `itk::Transform` data member `m_DirectionChange` ([0539a2c4dd](https://github.com/InsightSoftwareConsortium/ITK/commit/0539a2c4dd))

#### Platform Fixes

- Copy BSplineInterpolationWeightFunction::SupportSize within lambda ([27e4815bb8](https://github.com/InsightSoftwareConsortium/ITK/commit/27e4815bb8))
- Workaround VS2017 error C2653/C2886 using-declaration compiler bug ([066ddb8859](https://github.com/InsightSoftwareConsortium/ITK/commit/066ddb8859))
- Use trailing return type instead of `typename` + dependent type ([c54ad6715a](https://github.com/InsightSoftwareConsortium/ITK/commit/c54ad6715a))
- Fix KWStyle check errors from cxx files Modules/Core/Common/CMake ([809f14958a](https://github.com/InsightSoftwareConsortium/ITK/commit/809f14958a))
- Declare `IOFactoryRegisterManager` constructors `explicit` ([72782b8f01](https://github.com/InsightSoftwareConsortium/ITK/commit/72782b8f01))
- Remove pointer-to-bool conversions from `IOFactoryRegisterManager` ([49c910a1fe](https://github.com/InsightSoftwareConsortium/ITK/commit/49c910a1fe))
- Add "const" to `IOFactoryRegisterManager` implementations ([f56cc7ef17](https://github.com/InsightSoftwareConsortium/ITK/commit/f56cc7ef17))
- Fix error: constexpr variable 'ImageIOFactoryRegisterRegisterList' ([3ad34a16e8](https://github.com/InsightSoftwareConsortium/ITK/commit/3ad34a16e8))

#### Style Changes

- Use modern C++ `TRealValueType{ x }` syntax ([c9b05ab2f9](https://github.com/InsightSoftwareConsortium/ITK/commit/c9b05ab2f9))
- Improve const-correctness of protected CompositeTransform members ([a4693b5074](https://github.com/InsightSoftwareConsortium/ITK/commit/a4693b5074))
- Do not use itkGetStaticConstMacro in ITK/Modules/Filtering ([4408bd4b72](https://github.com/InsightSoftwareConsortium/ITK/commit/4408bd4b72))
- Replace itkStaticConstMacro ImageSink, BinaryGeneratorImageFilter ([f4e12a0b4b](https://github.com/InsightSoftwareConsortium/ITK/commit/f4e12a0b4b))
- FUTURE_LEGACY_REMOVE itkStaticConstMacro, itkGetStaticConstMacro ([bb217ca4a7](https://github.com/InsightSoftwareConsortium/ITK/commit/bb217ca4a7))
- clang-format AlignEscapedNewlines Left (for macro definitions) ([7829ef68ad](https://github.com/InsightSoftwareConsortium/ITK/commit/7829ef68ad))
- git blame should ignore "clang-format AlignEscapedNewlines Left" ([b3bceaf2b8](https://github.com/InsightSoftwareConsortium/ITK/commit/b3bceaf2b8))
- Use `auto` for declaration of variables initialized by `New()` ([828453d1bf](https://github.com/InsightSoftwareConsortium/ITK/commit/828453d1bf))
- Remove redundant overrides of Get and Set member functions ([5b155aec50](https://github.com/InsightSoftwareConsortium/ITK/commit/5b155aec50))


### Philip Cook (1):

#### Enhancements

- Test NIFTI I/O with small voxels ([6fc6164252](https://github.com/InsightSoftwareConsortium/ITK/commit/6fc6164252))


### Sean McBride (6):

#### Enhancements

- make BSplineWarping2Test run serially, as it's quite slow ([0836c79324](https://github.com/InsightSoftwareConsortium/ITK/commit/0836c79324))

#### Platform Fixes

- fixed compile errors due to incorrect superclass identification ([9e2b8841ef](https://github.com/InsightSoftwareConsortium/ITK/commit/9e2b8841ef))
- modified several sed invocations to be BSD compatible ([b76ff2cfe5](https://github.com/InsightSoftwareConsortium/ITK/commit/b76ff2cfe5))
- fixed various Wunused-but-set-variable warnings from Clang 13 ([b85f24600a](https://github.com/InsightSoftwareConsortium/ITK/commit/b85f24600a))

#### Bug Fixes

- fixed various threading errors in logging code, found by TSan ([9599fc6cc0](https://github.com/InsightSoftwareConsortium/ITK/commit/9599fc6cc0))

#### Style Changes

- fixed repeated spelling mistake/typo ([54731ef592](https://github.com/InsightSoftwareConsortium/ITK/commit/54731ef592))


### Simon Rit (3):

#### Enhancements

- test exception handling in multithreading ([24c3ad91db](https://github.com/InsightSoftwareConsortium/ITK/commit/24c3ad91db))

#### Bug Fixes

- fix exception handling in itk::PoolMultiThreader ([ec43890e1a](https://github.com/InsightSoftwareConsortium/ITK/commit/ec43890e1a))
- fix installation of the generated file expat_config.h ([9b74f7b38b](https://github.com/InsightSoftwareConsortium/ITK/commit/9b74f7b38b))


### Stephen R. Aylward (3):

#### Enhancements

- Bump TubeTK ([6c82281a35](https://github.com/InsightSoftwareConsortium/ITK/commit/6c82281a35))
- Bump TubeTK to v1.0.0 ([04a50e4cd6](https://github.com/InsightSoftwareConsortium/ITK/commit/04a50e4cd6))
- Use v1.0.0 for tag ([fc3178008f](https://github.com/InsightSoftwareConsortium/ITK/commit/fc3178008f))


### Tom Birdsong (8):

#### Enhancements

- Add ITKShape as a remote module ([fdd52cecc4](https://github.com/InsightSoftwareConsortium/ITK/commit/fdd52cecc4))
- Add 1D FFT classes from ITKUltrasound ([0487709dc6](https://github.com/InsightSoftwareConsortium/ITK/commit/0487709dc6))

#### Platform Fixes

- Replace itkStaticConstMacro with constexpr in 1D FFT classes ([cb25661a12](https://github.com/InsightSoftwareConsortium/ITK/commit/cb25661a12))

#### Bug Fixes

- Respect UseImageSpacing flag in LaplacianImageFilter ([8f7a832b14](https://github.com/InsightSoftwareConsortium/ITK/commit/8f7a832b14))
- Fixups for adding 1D FFT classes from ITKUltrasound to ITK ([9332084028](https://github.com/InsightSoftwareConsortium/ITK/commit/9332084028))
- Replace deprecated macro in 1D FFT classes ([2c2a48494c](https://github.com/InsightSoftwareConsortium/ITK/commit/2c2a48494c))

#### Style Changes

- Use itkGetConstMacro for getting 1D FFT direction ([d88c631d98](https://github.com/InsightSoftwareConsortium/ITK/commit/d88c631d98))
- Mark FFTW 1D FFT class destructors with `override` ([eb6001490b](https://github.com/InsightSoftwareConsortium/ITK/commit/eb6001490b))


### Ziv Yaniv (1):

#### Bug Fixes

- VersorTransform did not update offset in SetParameters ([fb64eb2a89](https://github.com/InsightSoftwareConsortium/ITK/commit/fb64eb2a89))


### Zlib-ng Upstream (1):

#### Miscellaneous Changes

- zlib-ng 2021-10-13 (a7b77369) ([394fd57aff](https://github.com/InsightSoftwareConsortium/ITK/commit/394fd57aff))


### ambrozicc1 (1):

#### Bug Fixes

- Disable all floating point exceptions ([cd3f05eb0b](https://github.com/InsightSoftwareConsortium/ITK/commit/cd3f05eb0b))


### josempozo (1):

#### Style Changes

- itkTimeVaryingBSplineVelocityFieldImageRegistrationMethod.hxx (#2722) ([52477f353f](https://github.com/InsightSoftwareConsortium/ITK/commit/52477f353f))




ITK Sphinx Examples Changes Since v5.3rc01
---------------------------------------------

### Dženan Zukić (1):

#### Bug Fixes

- filling the buffer was forgotten in CreateImage ([fc491a42](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/fc491a42))


### Hans Johnson (3):

#### Platform Fixes

- Remove unused typedefs from examples. ([202a4541](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/202a4541))
- Place all QUICKVIEW code in ifdef ([ca095ee2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ca095ee2))

#### Bug Fixes

- Missed setting file from command line. ([3930982d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3930982d))


### Jon Haitz Legarreta Gorroño (1):

#### Enhancements

- Add labeler workflow ([3f8d0a2b](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3f8d0a2b))


### Mathew Seng (1):

#### Enhancements

- BinaryMathematicalMorphology baseline testing ([a91c350b](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a91c350b))




ITK Software Guide Changes Since v5.3rc01
---------------------------------------------

### Jon Haitz Legarreta Gorroño (1):

#### Enhancements

- Add labeler workflow ([1fca7b9](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/1fca7b9))


### Niels Dekker (4):

#### Platform Fixes

- Fix compile errors from *.cxx files in SoftwareGuide/Cover/Source ([ca70c18](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/ca70c18))

#### Bug Fixes

- Replace "assigment" with "initialization" in the `auto` section ([fb9eb1e](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/fb9eb1e))

#### Style Changes

- In code examples, use `auto` for variables initialized by `New()` ([49c2bf0](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/49c2bf0))
- Use `auto` for declaration of variables initialized by `New()` ([d7f79dc](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/d7f79dc))




Remote Module Changes Since v5.3rc01
---------------------------------------------

## Shape:



## TubeTK:
### Stephen R. Aylward (9):

#### Enhancements

- Improve radius estimation and refactor tube-to-image registration framework (#82) ([ef72833a](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/ef72833a))
- Updated ITK to v5.3rc01 throughout github workflow ([119f23ca](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/119f23ca))
- Update Linux wheel to cp39 for github action ([575517b7](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/575517b7))
- Update version to 1.0 (#89) ([cee053ac](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/cee053ac))

#### Bug Fixes

- MultiThreader not needed to set number of workers (#84) ([d487bc13](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/d487bc13))
- Spatial Object Registration Optimization (#86) ([3911cc78](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/3911cc78))
- Fix cmd-line args to RegisterSpatialObjectsToImage app ([9d052906](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/9d052906))
- Create link to oneTBB for linux ([b0670cf1](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b0670cf1))

#### Miscellaneous Changes

- Fix dashboards (#83) ([e6a435c7](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/e6a435c7))
